#ifndef LIVEHEATMAPGPUAPP_CPP
#define LIVEHEATMAPGPUAPP_CPP

#include "LiveHeatMapGPUApp.hpp"

LiveHeatMapGPUApp::LiveHeatMapGPUApp ( const int argc, const char* argv[] )
: FileApplication( argc, argv )
{
	this->parseOptions( argc, argv );
}

const Frame&	LiveHeatMapGPUApp::saliencyMap	() const	{ return this->_saliencyMap;	}
Frame&			LiveHeatMapGPUApp::saliencyMap	()			{ return this->_saliencyMap;	}
const Frame&	LiveHeatMapGPUApp::heatMap		() const	{ return this->_heatMap;		}
Frame&			LiveHeatMapGPUApp::heatMap		()			{ return this->_heatMap;		}

int LiveHeatMapGPUApp::run ()
{
	// Open the files
	this->FileApplication::run();

	// Main Loop
	while ( !this->hasFinished() )
	{
		this->mutex().lock();

		if ( this->heatMap().cols > 0 && this->heatMap().rows > 0 )
			this->displayFrame( this->heatMap() );

		this->mutex().unlock();
	}
	return EXIT_SUCCESS;
}

void LiveHeatMapGPUApp::receiveSynkedData ( FramePtr ptrFrame, GazeFixationPtr ptrFixation )
{
	this->mutex().lock();
	this->ptrFrame() = ptrFrame;
	this->ptrFixation() = ptrFixation;

	if ( ptrFrame && ptrFixation )
	{
		// Compute
		this->saliencyMap() = Saliency::computeSaliencyMapGPU( *this->ptrFixation(), this->ptrFrame()->size() );
		this->heatMap()     = Saliency::computeHeatMap( *this->ptrFrame(), this->saliencyMap(), 0.6 );

		// Record in the output video / dump (if option is set)
		this->recordFrame( this->heatMap() );
		this->dumpFrame( this->heatMap(), ptrFrame->timeStamp() );
	}

	this->mutex().unlock();
}

#endif // LIVEHEATMAPGPUAPP_CPP