#ifndef LIVEGAZEAPP_CPP
#define LIVEGAZEAPP_CPP

#include "LiveGazeApp.hpp"
#include <iostream>

LiveGazeApp::LiveGazeApp ( const int argc, const char* argv[] )
: Tobii::FileApplication( argc, argv )
{
	this->parseOptions( argc, argv );
}

int LiveGazeApp::run ()
{
	// Open the files
	this->FileApplication::run();

	// Mainloop
	while ( !this->hasFinished() )
	{
		// Stop the reading / computing threads
		this->mutex().lock();

		if ( this->ptrFrame() && this->ptrFrame()->cols > 0 && this->ptrFrame()->rows > 0  )
		{
			this->displayFrame( *this->ptrFrame() );
		}

		// Restart the reading / computing threads
		this->mutex().unlock();
	}

	return EXIT_SUCCESS;
}

void LiveGazeApp::receiveSynkedData ( Tobii::FramePtr ptrFrame, Tobii::GazeFixationPtr ptrFixation )
{
	// Stop the main thread
	this->mutex().lock();

	double sigma = Tobii::Saliency::sigmaAtResolution( ptrFrame->size() );

	// check if the 3D position is valid data
	if ( ptrFixation->isFieldSet( Tobii::GazeFixation::ValidityFlag::DISTANCE ) )
		sigma = Tobii::Saliency::computeSigma( *ptrFixation, ptrFrame->size() );

	// check if the 2D position is valid data
	if ( ptrFixation->isFieldSet( Tobii::GazeFixation::ValidityFlag::POSITION_2D ) )
	{
		// Draw the gaze
		cv::Point position(
			ptrFixation->position2D().x()*ptrFrame->cols,
			ptrFixation->position2D().y()*ptrFrame->rows
		);
		cv::circle( *ptrFrame, position, sigma, cv::Scalar(0,0,255), 2 );
	}

	// Record in the output video / dump (if option is set)
	this->recordFrame( *ptrFrame );
	this->dumpFrame( *ptrFrame );

	// Copy them for display in main thread
	this->ptrFrame() = ptrFrame;
	this->ptrFixation() = ptrFixation;

	// Restart the main thread
	this->mutex().unlock();
}

#endif // LIVEGAZEAPP_CPP