#include "TobiiSDK/Saliency.hpp"
#include <iostream>
#include <opencv2/core/core.hpp>
#include <opencv2/highgui/highgui.hpp>

using String = const char*;

int main ( int argc, char* argv[] )
{
	using namespace Tobii;

	if ( argc < 2 )
	{
		std::cerr << "USAGE: " << argv[0] << " 'videoFrameName' 'saliencyFrameName' [outputFrameName=./WeightedMap.png]" << std::endl << std::flush;
		return -1;
	}

	String    videoFrameName = argv[1];
	String saliencyFrameName = argv[2];
	String   outputFrameName = (argc >= 3 ? argv[3] : "./WeightedMap.png");

	std::cout
		<< "Computing heat-map visualisation for images:"			<< std::endl
		<< ">\t   videoFrameName: \"" << videoFrameName		<< "\""	<< std::endl
		<< ">\tsaliencyFrameName: \"" << saliencyFrameName	<< "\""	<< std::endl
		<< ">\t  outputFrameName: \"" << outputFrameName	<< "\""	<< std::endl
		<< ">" << std::endl
		<< "> Loading images ... " << std::flush;

	Frame video   ( 0, 0, cv::imread( videoFrameName,    CV_LOAD_IMAGE_COLOR ) );
	Frame saliency( 0, 0, cv::imread( saliencyFrameName, CV_LOAD_IMAGE_COLOR ) );

	if ( video.size() == saliency.size() )
		std::cout << "Done!" << std::endl;
	else
	{
		std::cout << "Error: Size of images do not match " << video.size() << " != " << saliency.size() << std::endl << std::flush;
		return -1;
	}

	std::cout
		<< "> Computing WeightedMap ... " << std::flush;

	Frame heatmap  = Saliency::computeWeightedMap( video, saliency );
	cv::imwrite( outputFrameName, heatmap );

	std::cout
		<< "Done!" << std::endl
		<< "> WeightedMap was saved in file \"" << outputFrameName << "\"." << std::endl << std::flush;

	return 0;
}