// ##################################################
// ###            TOBII_VIDEODISPLAY_HPP          ###
// ##################################################
#ifndef TOBII_VIDEODISPLAY_HPP
#define TOBII_VIDEODISPLAY_HPP

/**
 * \file VideoDisplay.hpp
 * \brief VideoDisplay of the Tobii GUI Application
 * \author PÉREZ DE SAN ROMAN Philippe
 * \date 16/02/2016
 * \version 1.0
 **/

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// INTERNAL MODULES
#include "TobiiSDK/Data/Frame.hpp"

// EXTERNAL LIBRARIES
#include <QLabel>
#include <opencv2/imgproc/imgproc.hpp>

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

/**
 * \namespace Tobii
 * 
 * Regroups all Tobii Glasses 2 SDK related types and algorithmes.
 **/
namespace Tobii {

	// ##################################################
	// ###             CLASS MAINWINDOW               ###
	// ##################################################

	class VideoDisplay : public QLabel
	{
		Q_OBJECT
	public:
		VideoDisplay ( QWidget* ptrParent = NULL );

	public slots:
		void setFrame ( const Frame& frame, double zoomFactor = 1.0 );

	}; // END CLASS MAINWINDOW
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################


#endif // TOBII_VIDEODISPLAY_HPP
// ##################################################