// ##################################################
// ###            TOBII_VIDEODISPLAY_CPP          ###
// ##################################################
#ifndef TOBII_VIDEODISPLAY_CPP
#define TOBII_VIDEODISPLAY_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "VideoDisplay.hpp"
#include <QDebug>

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

/**
 * \namespace Tobii
 * 
 * Regroups all Tobii Glasses 2 SDK related types and algorithmes.
 **/
namespace Tobii {

	// ##################################################
	// ###             CLASS MAINWINDOW               ###
	// ##################################################
	
	VideoDisplay::VideoDisplay ( QWidget* ptrParent )
	: QLabel( ptrParent )
	{}

	void VideoDisplay::setFrame ( const Frame& frame, double zoomFactor )
	{
		if ( frame.cols != 0 && frame.rows != 0 )
		{
			cv::Mat inMat = frame;
			
			if ( zoomFactor != 1.0 )
				cv::resize(inMat, inMat, cv::Size( floor(inMat.cols*zoomFactor), floor(inMat.rows*zoomFactor) ));
			
			cv::cvtColor( inMat, inMat, CV_BGR2RGB );
			QImage image( inMat.data, inMat.cols, inMat.rows, inMat.step, QImage::Format_RGB888 );
			this->setPixmap( QPixmap::fromImage(image) );
		}
	}

	// END CLASS MAINWINDOW
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################


#endif // TOBII_VIDEODISPLAY_CPP
// ##################################################