// ##################################################
// ###              TOBII_STARTPAGE_HPP           ###
// ##################################################
#ifndef TOBII_STARTPAGE_HPP
#define TOBII_STARTPAGE_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// EXTERNAL LIBRARIES
#include <QWidget>
#include <QVBoxLayout>
#include <QFileDialog>

// GENERATED HEADERS
#include "ui_StartPage.h"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

namespace Tobii {

	// ##################################################
	// ###              CLASS START-PAGE              ###
	// ##################################################

	class StartPage : public QDockWidget, private Ui::StartPage
	{
	    Q_OBJECT
	private:
		static const QString IconOpen;
		
	public:
		StartPage ( const QString& workspace, const QString& categories, QWidget* ptrParent = NULL );

		const QVBoxLayout*	recentProjectsLayout () const;
		QVBoxLayout*		recentProjectsLayout ();

	private slots:
	    void on_butNew_clicked		();
	    void on_butOpen_clicked		();
	    void on_butImport_clicked	();
	    void on_butWorkspace_clicked ();
	    void on_lineWorkspace_textChanged ( const QString& text );
		void on_butCategories_clicked ();
	    void on_lineCategories_textChanged ( const QString& text );

	signals:
		void newProject			();
		void openProject		();
		void importProject		();
		void workspaceChanged	( const QString& folder );
		void categoriesChanged	( const QString& file );

	
	}; // END CLASS START-PAGE
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_STARTPAGE_HPPz
// ##################################################
