// ##################################################
// ###             TOBII_MAINWINDOW_HPP           ###
// ##################################################
#ifndef TOBII_MAINWINDOW_HPP
#define TOBII_MAINWINDOW_HPP

/**
 * \file MainWindow.hpp
 * \brief MainWindow of the Tobii GUI Application
 * \author PÉREZ DE SAN ROMAN Philippe
 * \date 16/02/2016
 * \version 1.0
 **/

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// EXTERNAL LIBRARIES
#include <QtWidgets>
#include <QDebug>

// INTERNAL MODULES
#include "StartPage.hpp"
#include "ProjectPage.hpp"
#include "ImportationWizard.hpp"
#include "TobiiSDK/Importer.hpp"

 // GENERATED UI
 #include "ui_MainWindow.h"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

/**
 * \namespace Tobii
 * 
 * Regroups all Tobii Glasses 2 SDK related types and algorithmes.
 **/
namespace Tobii {

	// ##################################################
	// ###             CLASS MAINWINDOW               ###
	// ##################################################

	class MainWindow : public QMainWindow, Ui::MainWindow
	{
		Q_OBJECT
	private:
		QSettings	_settings;
		QString		_workspace;
		QString		_categoryFile;
		StartPage*	_ptrStartPage;

		// --------------------------------------------------
		// CONSTRUCTOR - DESTRUCTOR
	public:
		MainWindow ();
		~MainWindow ();

		// --------------------------------------------------
		// GETTERS - SETTERS

		const QSettings&	settings		() const;
		QSettings&			settings		();
		const QString&		workspace		() const;
		QString&			workspace		();
		const QString&		categoryFile	() const;
		QString&			categoryFile	();
		const StartPage*	ptrStartPage	() const;
		StartPage*&			ptrStartPage	();

		void addProjectPage ( ProjectPage* page );
		ProjectPage* getProjectPage ();

		// --------------------------------------------------
		// INIT MENUS

		void initMenuProject ();
		void initMenuEdit	 ();

		// --------------------------------------------------
		// SLOTS
	private slots:
		void projectNewEvent	();
		void projectOpenEvent	();
	//  void projectSaveEvent	();
	//  void projectSaveAsEvent	();
		void projectImportEvent	();
	//  void projectExportEvent	();
		void projectCloseEvent	();

		void quitEvent ();

	//  void editUndoEvent	();
	//  void editRedoEvent	();
	//  void editCopyEvent	();
	//  void editCutEvent	();
	//  void editPastEvent	();

		void setWorkspace	( const QString& folder );
		void setCategories	( const QString& file );
		void fitToPage		(const QSize& size );

	}; // END CLASS MAINWINDOW
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_MAINWINDOW_HPP
// ##################################################