// ##################################################
// ###          TOBII_IMPORTATIONWIZARD_HPP       ###
// ##################################################
#ifndef TOBII_IMPORTATIONWIZARD_HPP
#define TOBII_IMPORTATIONWIZARD_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// EXTERNAL LIBRARIES
#include <QtWidgets>

// GENERATED UI HEADER
#include "ui_ImportationWizard.h"

// INTERNAL MODULES
#include "TobiiSDK/ImportationOptions.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

namespace Tobii {

	// ##################################################
	// ###         CLASS INTEPORTATION-WIZARD         ###
	// ##################################################

	class ImportationWizard : public QDialog, private Ui::ImportationWizard
	{
	    Q_OBJECT
	private:
		QString _folder;

	public:
		ImportationWizard ( const QString& folder = QDir::homePath(), QWidget* ptrParent = NULL );

	private:
		const QString&	folder	() const;
		QString&		folder	();

	private slots:
	    void on_pbPickVideo_clicked		();
	    void on_pbPickGaze_clicked		();
	    void on_buttonBox_accepted		();
	    void on_buttonBox_rejected		();
	    void on_cbSaliency_stateChanged	(int state);
	    void on_cbHeat_stateChanged		(int state);
	    void on_cbWeighted_stateChanged	(int state);

	signals:
		void accepted ( const ImportationOptions& options );
	
	}; // END CLASS INTEPORTATION-WIZARD
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_IMPORTATIONWIZARD_HPP
// ##################################################
