// ##################################################
// ###            TOBII_CONTROLEPANEL_HPP         ###
// ##################################################
#ifndef TOBII_CONTROLEPANEL_HPP
#define TOBII_CONTROLEPANEL_HPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

// INTERNAL DEPENDANCES
#include "TobiiSDK/Stream/Project.hpp"

// EXTERNAL LIBRARIES
#include <QtWidgets>

// UI HEADER
#include "ui_ControlePanel.h"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

/**
 * \namespace Tobii
 * 
 * Regroups all Tobii Glasses 2 SDK related types and algorithmes.
 **/
namespace Tobii {

	// ##################################################
	// ###           CLASS CONTROLE-PANEL             ###
	// ##################################################

	class ControlePanel : public QWidget, public Ui::ControlePanel
	{
		Q_OBJECT
	private:
		static const QString IconPlay, IconPause, IconPrevious, IconNext, IconPick;

		QTimer _player;

		// --------------------------------------------------
		// CONSTRUCTOR
	public:
		ControlePanel ( QWidget* ptrParent = NULL );

		// --------------------------------------------------
		// GETTERS

		const QTimer&	player	() const;
		QTimer&			player	();

		QString currentView	() const;
		QString gategory	() const;

		// --------------------------------------------------
		// SETTERS

		void setProjectData	( const ProjectPtr& ptrProject );
		void setFrameData	( Int64 index, Int64 indexMax, Int64 timeStamp );

		void setFrameFrom	( int timeStamp );
		void setFrameTo		( int timeStamp );
		void setCategories	( const QString& filename );
		void setCategories	( const QStringList& categories );

		// --------------------------------------------------
		// SLOTS
	private slots:
		void on_butPrevious_clicked			();
		void on_butPlayPause_clicked		();
		void on_butNext_clicked				();
		void on_cbView_currentTextChanged	( const QString& text );
		void on_cbZoom_currentTextChanged	( const QString& text );

		void on_butPickFromFrame_clicked	();
		void on_butPickToFrame_clicked		();
		void on_sbThreshold_valueChanged	( double value );
		void on_butCompute_clicked			();

		void on_cbCategories_currentTextChanged ( const QString& text );

	signals:
		void videoNextFrame		();
		void videoPreviousFrame	();
		void videoSetView		( QString view );
		void videoShowGaze		( bool state );
		void videoSetZoomFactor ( double factor );
		void frameFromPicked	();
		void frameToPicked		();
		void threshodChanged	( double threshold );
		void computeAnnotation	();
		void categoryChanged	( const QString& text );

	#define TRACK_STATS 1
	#ifdef  TRACK_STATS
	private:
		QTimer			_timer;
		QTime			_startTime;
		const QTimer&	timer		() const;
		QTimer&			timer		();
		const QTime&	startTime	() const;	
		QTime&			startTime	();	
		Int64			timeElapsed	() const;

	private slots:
		void timerCallback();
		void on_butTimerStart_clicked ();
		void on_butTimerSave_clicked ();

	signals:
		void resetStatistics ();
		void saveStatistics  ( int timeElapsed );
	#endif

	}; // END CLASS CONTROLE-PANEL
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_CONTROLEPANEL_HPP
// ##################################################