// ##################################################
// ###            TOBII_CONTROLEPANEL_CPP         ###
// ##################################################
#ifndef TOBII_CONTROLEPANEL_CPP
#define TOBII_CONTROLEPANEL_CPP

// ##################################################
// ###                 DEPENDENCES                ###
// ##################################################

#include "ControlePanel.hpp"

// ##################################################
// ###              NAMESPACE TOBII               ###
// ##################################################

namespace Tobii {

	// ##################################################
	// ###           CLASS CONTROLE-PANEL             ###
	// ##################################################

	const QString ControlePanel::IconPlay		( "./Sources/Binaries/AnnotationTool/Ressources/video_play.png"				);
	const QString ControlePanel::IconPause		( "./Sources/Binaries/AnnotationTool/Ressources/video_pause.png" 			);
	const QString ControlePanel::IconPrevious	( "./Sources/Binaries/AnnotationTool/Ressources/video_previous_frame.png"	);
	const QString ControlePanel::IconNext		( "./Sources/Binaries/AnnotationTool/Ressources/video_next_frame.png" 		);
	const QString ControlePanel::IconPick		( "./Sources/Binaries/AnnotationTool/Ressources/pick.png" 					);

	const QTimer&	ControlePanel::player	() const	{ return this->_player;	}
	QTimer&			ControlePanel::player	()			{ return this->_player;	}

	ControlePanel::ControlePanel ( QWidget* ptrParent )
	: QWidget( ptrParent ), _player(this)
	{
		this->setupUi( this );

		this->butPlayPause->setIcon( QIcon(ControlePanel::IconPlay) );
		this->butPrevious->setIcon( QIcon(ControlePanel::IconPrevious) );
		this->butNext->setIcon( QIcon(ControlePanel::IconNext) );
		this->butPickFromFrame->setIcon( QIcon(ControlePanel::IconPick) );
		this->butPickToFrame->setIcon( QIcon(ControlePanel::IconPick) );

		this->cbView->clear();

		connect( &this->player(), SIGNAL(timeout()), this, SLOT(on_butNext_clicked()) );

		#ifndef TRACK_STATS
			this->timerDisplay->setEnabled( false );
			this->butTimerStart->setEnabled( false );
			this->butTimerSave->setEnabled( false );
		#else
			this->timerDisplay->setEnabled( true );
			this->butTimerStart->setEnabled( true );
			this->butTimerSave->setEnabled( false );
			connect( &this->timer(), SIGNAL(timeout()), this, SLOT(timerCallback()) );
		#endif
	}

	QString ControlePanel::currentView () const
	{
		return this->cbView->currentText();
	}

	QString ControlePanel::gategory () const
	{
		return this->cbCategories->currentText();
	}


	void ControlePanel::setProjectData ( const ProjectPtr& ptrProject )
	{
		this->cbView->clear();
		QStringList views;
		for ( const QString& view : ptrProject->streamNames() )
		{
			if ( view == Project::Saliency )
				views << Project::Saliency << Project::SaliencyHeatMap << Project::SaliencyWeightedMap;
			else if ( view == Project::Annotation )
				views << Project::Annotation << Project::AnnotationHeatMap << Project::AnnotationWeightedMap;
			else
				views << view;
		}
		this->cbView->addItems( views );

		this->cbCategories->setCurrentText( ptrProject->categories()[0] );

		this->labVideoName->setText( QString("Name: %1").arg(ptrProject->name()) );
		this->labResolution->setText( QString("Resolution: %1x%2").arg(ptrProject->resolution().width).arg(ptrProject->resolution().height) );
		this->labFPS->setText( QString("FPS: %1").arg( ptrProject->fps() ) );

		this->setFrameFrom ( ptrProject->firstTimeStamp() );
		this->setFrameTo   ( ptrProject->lastTimeStamp()  );
	}

	void ControlePanel::setFrameData ( Int64 index, Int64 count, Int64 timeStamp )
	{
		this->butPlayPause->setEnabled( true );
		this->butPrevious->setEnabled( true );
		this->butNext->setEnabled( true );

		this->labFrame->setText( QString("Frame N°%1/%2 : %3ms").arg(index+1).arg(count).arg(timeStamp) );

		if ( index == 0 )
			this->butPrevious->setEnabled( false );

		if ( index == count-1 )
		{
			this->butNext->setEnabled( false );
			this->butPlayPause->setEnabled( false );

			if ( this->player().isActive() )
				this->player().stop();
		}
	}

	void ControlePanel::setFrameFrom ( int timeStamp )
	{
		this->labFromFrame->setText( QString("From %1ms").arg(timeStamp) );
	}

	void ControlePanel::setFrameTo ( int timeStamp )
	{
		this->labToFrame->setText( QString("To %1ms").arg(timeStamp) );
	}

	void ControlePanel::setCategories ( const QString& filename )
	{
		if ( ! filename.isEmpty() )
		{
			// Open te file
			QFile file( filename );
			if ( ! file.open(QIODevice::ReadOnly | QIODevice::Text) )
	       		return;

	       	// Init the list of gategories
	       	QStringList categories;
			QRegExp separators("(\\ |\\,|\\.|\\:|\\t|\\;)");

	       	// Read the file in text format
	       	QTextStream in( &file );
			while ( ! in.atEnd() )
			{
				categories << in.readLine().split( separators, QString::SkipEmptyParts );
			}
			categories << "Unknown";
			categories.removeDuplicates();
			this->setCategories( categories );
		}
	}

	void ControlePanel::setCategories ( const QStringList& categories )
	{
		this->cbCategories->clear();
		this->cbCategories->addItems( categories );
	}


	void ControlePanel::on_butPrevious_clicked ()
	{
		emit this->videoPreviousFrame();
	}

	void ControlePanel::on_butPlayPause_clicked ()
	{
		enum State : bool { Play, Pause };
		static State state( State::Play );

		if ( state == State::Play )
		{
			this->player().start( 40 );

			state = State::Pause;
			this->butPlayPause->setIcon( QIcon(ControlePanel::IconPause) );
		}
		else
		{
			this->player().stop();

			state = State::Play;
			this->butPlayPause->setIcon( QIcon(ControlePanel::IconPlay) );
		}
	}

	void ControlePanel::on_butNext_clicked ()
	{
		emit this->videoNextFrame();
	}

	void ControlePanel::on_cbView_currentTextChanged ( const QString& text )
	{
		if ( ! text.isEmpty() )
			emit this->videoSetView( text );
	}

	void ControlePanel::on_cbZoom_currentTextChanged ( const QString& text )
	{
		if ( ! text.isEmpty() )
		{
			double factor( 1.0 );

			if ( text == "100%" )
				factor = 1.00;
			else if ( text == "75%" )
				factor = 0.75;
			else if ( text == "50%" )
				factor = 0.50;
			else if ( text == "25%" )
				factor = 0.25;

			emit this-> videoSetZoomFactor( factor );
		}
	}

	void ControlePanel::on_butPickFromFrame_clicked ()
	{
		emit this->frameFromPicked();
	}

	void ControlePanel::on_butPickToFrame_clicked ()
	{
		emit this->frameToPicked();
	}

	void ControlePanel::on_sbThreshold_valueChanged ( double value )
	{
		emit this->threshodChanged( value );
	}

	void ControlePanel::on_butCompute_clicked ()
	{
		emit this->computeAnnotation();
	}

	void ControlePanel::on_cbCategories_currentTextChanged ( const QString& text )
	{
		emit this->categoryChanged( text );
	}

#ifdef TRACK_STATS
	const QTimer&	ControlePanel::timer		() const	{ return this->_timer;			}
	QTimer&			ControlePanel::timer		()			{ return this->_timer;			}
	const QTime&	ControlePanel::startTime	() const	{ return this->_startTime;		}
	QTime&			ControlePanel::startTime	()			{ return this->_startTime;		}
	Int64			ControlePanel::timeElapsed	() const	{ return this->startTime().elapsed();	}

	void ControlePanel::timerCallback ()
	{
		this->timerDisplay->setText( QString("%1 ms").arg(this->timeElapsed()) );
	}

	void ControlePanel::on_butTimerStart_clicked ()
	{
		emit this->resetStatistics();
		this->timerCallback();
		this->butTimerSave->setEnabled( true );
		this->startTime().start();
		this->timer().start(1);
		this->butTimerStart->setText("Restart");
	}

	void ControlePanel::on_butTimerSave_clicked ()
	{
		emit this->saveStatistics( this->timeElapsed() );
		this->timer().stop();
	}
#endif

	// END CLASS CONTROLE-PANEL
	// ##################################################

} // END NAMESPACE TOBII
// ##################################################

#endif // TOBII_CONTROLEPANEL_CPP
// ##################################################