#!/bin/bash

##################################################
echo "DatabaseAssembler: Welcome"

call_dir="$(pwd)"
current_dir="$(cd "$(dirname "$0")"; pwd)"
root_dir="$(cd "$current_dir"; cd ..; cd ..; pwd)"

##################################################
echo "Assembling training database: Starting"

GLOG_logtostderr=1 "$call_dir/ImageNet/caffe-master/build/tools/convert_imageset" \
	-resize_width 227 \
	-resize_height 227 \
	-shuffle \
	-check_size \
	/ \
	./Workspace/Samples/Test6/IndexTrain.txt \
	./Workspace/Database/Test6/Train.lmdb

echo "Assembling training database: Finished"

##################################################
echo "Computing training database mean: Starting"

GLOG_logtostderr=1  "$call_dir/ImageNet/caffe-master/build/tools/compute_image_mean" \
	./Workspace/Database/Test6/Train.lmdb \
	./Workspace/Database/Test6/Train.lmdb/Mean.binaryproto

echo "Computing training database mean: Finished"

##################################################
echo "Assembling validation database: Starting"

GLOG_logtostderr=1 "$call_dir/ImageNet/caffe-master/build/tools/convert_imageset" \
	-resize_width 227 \
	-resize_height 227 \
	-shuffle \
	-check_size \
	/ \
	./Workspace/Samples/Test6/IndexValidation.txt \
	./Workspace/Database/Test6/Validation.lmdb

echo "Assembling validation database: Finshed"

##################################################
echo "DatasetAssembler: Good By"
