import numpy as np
import cv2
from matplotlib import pyplot as plt
import matplotlib.image as mpimg
import sys
import os
from scipy import stats
from math import sqrt

def compute_norm_fixation(x,y,M):
	l = [x, y, 1]
	homog_coor = np.asarray(l)
	new_homoh_coor = M.dot(homog_coor)
	cart = [new_homoh_coor.item(0)/new_homoh_coor.item(2),new_homoh_coor.item(1)/new_homoh_coor.item(2)]
	return (cart[0],cart[1])

def distance(c1,c2):
	return sqrt((c1[0]-c2[0])**2 + (c1[1]-c2[1])**2)


d_objets = [ f for  f in os.listdir('normalized_images/') if not os.path.isfile(os.path.join('.',f))]
for dossier in d_objets:
	d_instances = [ f for  f in os.listdir('normalized_images/' + dossier) if not os.path.isfile(os.path.join('.',f))]
	for inst in d_instances:
		if os.path.isfile('normalized_images/' + dossier + '/' + inst + '/homographies_mid.txt'):
			
			# initialisations
			ratio = 0
			nb = 0
			f_res_1 = open('images/' + dossier + '/' + inst + "/annotation_1.txt","w") # projection of the real center
			f_res_2 = open('images/' + dossier + '/' + inst + "/annotation_2.txt","w") # projection of the estimated center
			f_res_3 = open('images/' + dossier + '/' + inst + "/annotation_3.txt","w") # real coordinates and their distance with the real center
			f_res_4 = open('images/' + dossier + '/' + inst + "/annotation_4.txt","w") # real coordinates and their distance with the estimated center
			f_coord_mid = open('normalized_images/' + dossier + '/' + inst + "/coordinates_mid.txt","r")

			# get the center of the kde
			f_center_kde = open('normalized_images/' + dossier + '/' + inst + '/center_kde.txt','r')
			center_kde = [float(c) for c in f_center_kde.readline().split()]
			f_center_kde.close()

			# get the real center
			f_center_real = open('normalized_images/' + dossier + '/' + inst + '/center_coord.txt','r')
			center_real = [float(c) for c in f_center_real.readline().split()]
			f_center_real.close()

			# get the homographies
			f_data = open('normalized_images/' + dossier + '/' + inst + '/homographies_mid.txt','r')
			homographies = []
			for line in f_data:
				homographies.append(line[:len(line)-1])
			f_data.close()
			

			# store the fixation of the annotated segment
			fichier = open('images/' + dossier + '/' + inst + "/annotation.txt","r")
			l0 = [0,0,0,0]
			l_fix = []
			while l0[1] != '1':
				l = fichier.readline()
				l0 = l.split()
				if l0[1] != '1':
					f_res_1.write(l)
					f_res_2.write(l)
					f_res_3.write(l)
					f_res_4.write(l)	

			while l0[1] != '0':
				l_fix.append(l0)
				l0 = fichier.readline().split()


			# get the middle image as the destination and draw its fixation
			ind_mid = int(len(l_fix)/2)-1
			l_ref = l_fix[ind_mid]
			l_dst = l_ref
			img_ref = cv2.imread('images/' + dossier + '/' + inst + '/Frames/' + l_ref[0] + '.jpg',0)
			img_dst = img_ref
			img0 = cv2.cvtColor(img_ref,cv2.COLOR_GRAY2RGB)
			width, height = img0.shape[:2]
			coord = []
			name = []


			
			# compute the normalized fixations for the previous frames
			M = np.eye(3,3)
			data = []
			coord_kde = []
			coord_real = []
			for k in range(ind_mid-1,-1,-1):

				l_src = l_fix[k]

				# get the corresponding homography
				Mk = np.array(homographies[k])
				if Mk != '[]':
					l = str(Mk)
					l = l[1:len(l)-1].split(',')
					Mk = [float(v) for v in l]
					Mk = np.reshape(np.asarray(Mk),(3,3))
					M = Mk.dot(M)

					# project the fixation point 
					(x_res, y_res) = compute_norm_fixation(float(center_kde[1]),float(center_kde[0]),np.linalg.inv(M))
					coord_kde.append((x_res,y_res))
					(x_res, y_res) = compute_norm_fixation(float(center_real[1]),float(center_real[0]),np.linalg.inv(M))
					coord_real.append((x_res,y_res))
					name.append(l_src[0])
		
					# go on to the next frame
					l_dst = l_src


			# write the homographies
			coord_kde = coord_kde[::-1]
			coord_real = coord_real[::-1]
			name = name[::-1]
			coord_real.append((center_real[1],center_real[0]))
			coord_kde.append((center_kde[1],center_kde[0]))
			name.append(l_ref[0])


			# compute the normalized fixations for the next frames
			M = np.eye(3,3)
			img_dst = img_ref
			l_dst = l_ref
			for k in range(ind_mid+1,len(l_fix)):

				l_src = l_fix[k]

				# get the corresponding homography
				Mk = np.array(homographies[k-1])
				if Mk != '[]':
					l = str(Mk)
					l = l[1:len(l)-1].split(',')
					Mk = [float(v) for v in l]
					Mk = np.reshape(np.asarray(Mk),(3,3))
					M = M.dot(Mk)

					# project the fixation point 
					(x_res, y_res) = compute_norm_fixation(float(center_kde[1]),float(center_kde[0]),M)
					coord_kde.append((x_res,y_res))
					(x_res, y_res) = compute_norm_fixation(float(center_real[1]),float(center_real[0]),M)
					coord_real.append((x_res,y_res))
					name.append(l_src[0])
		
					# go on to the next frame
					l_dst = l_src


				
			# write the projections of the real coordinates
			for k in range(len(coord_real)):
				(x,y) = coord_real[k]
				n = name[k]
				f_res_1.write(n + ' 1 ' + str(int(x)) + ' ' + str(int(y))+'\n')
			f_res_1.write(l0[0] + ' 0 ' + l0[2] + ' ' + l0[3]+'\n')

			# write the projections of the estimated coordinates
			for k in range(len(coord_kde)):
				(x,y) = coord_kde[k]
				n = name[k]
				f_res_2.write(n + ' 1 ' + str(int(x)) + ' ' + str(int(y))+'\n')
			f_res_2.write(l0[0] + ' 0 ' + l0[2] + ' ' + l0[3]+'\n')

			# read the fixations coordinates projected on the middle frame
			mid_coor = []
			for line in f_coord_mid:
				mid_coor.append(line.split())
			f_coord_mid.close()
			mid_coor2 = mid_coor[:ind_mid]
			mid_coor2.append([l_ref[3],l_ref[2]])
			mid_coor = mid_coor2 + mid_coor[ind_mid:]


			# write the distances with the real coordinates
			for k in range(len(coord_real)):
				c = mid_coor[k]
				l = l_fix[k]
				d = distance((float(c[0]),float(c[1])),(center_real[0],center_real[1]))
				f_res_3.write(l[0] + ' ' + l[1] + ' ' + l[2] + ' ' + l[3] + ' ' + str(d) + '\n')
			f_res_3.write(l0[0] + ' 0 ' + l0[2] + ' ' + l0[3]+'\n')

			# write the distances with the kde coordinates
			for k in range(len(coord_kde)):
				c = mid_coor[k]
				l = l_fix[k]
				d = distance((float(c[0]),float(c[1])),(center_kde[0],center_kde[1]))
				f_res_4.write(l[0] + ' ' + l[1] + ' ' + l[2] + ' ' + l[3] + ' ' + str(d) + '\n')
			f_res_4.write(l0[0] + ' 0 ' + l0[2] + ' ' + l0[3]+'\n')


			for line in fichier:
				f_res_1.write(line)
				f_res_2.write(line)
				f_res_3.write(line)
				f_res_4.write(line)
			f_res_1.close()
			f_res_2.close()
			f_res_3.close()
			f_res_4.close()

		

			
			
			fichier.close()


		


		



		



