import numpy as np
import cv2
from matplotlib import pyplot as plt
import matplotlib.image as mpimg
import sys
import os
from scipy import stats
from threading import Thread

class thread_class(Thread):

	def __init__(self,d_obj):
		Thread.__init__(self)
		self.d_objets = d_obj

	def run(self):
		width = 540
		height = 960
		for dossier in self.d_objets:
			d_instances = [ f for  f in os.listdir('normalized_images/' + dossier) if not os.path.isfile(os.path.join('.',f))]
			for inst in d_instances:
				print '     ' + inst

				f = open('normalized_images/' + dossier + '/' + inst + '/coordinates_mid.txt','r')
				x = []
				y = []
				for line in f:
					c = line.split()
					x.append(float(c[0]))
					y.append(float(c[1]))
				f.close()
				data = np.vstack([x, y])
				kernel = stats.gaussian_kde(data)
				values = np.zeros((width,height))
				maxi = -1
				coor = (0,0)
				for i in range(width):
					for j in range(height):
						if kernel((i,j)) > maxi:
							coor = (i,j)
							maxi = kernel((i,j))
				f_kde = open('normalized_images/' + dossier + '/' + inst + '/center_kde.txt','w')
				f_kde.write(str(coor[0]) + ' ' + str(coor[1]))
				f_kde.close()
	
d_objets = [ f for  f in os.listdir('normalized_images/') if not os.path.isfile(os.path.join('.',f))]
nb_threads = 4
size_sub_list = int(len(d_objets)/nb_threads)
l_thread = []
for k in range(nb_threads):
	d_obj = d_objets[k*size_sub_list:min((k+1)*size_sub_list,len(d_objets))]
	thread = thread_class(d_obj)
	thread.start()
	l_thread.append(thread)

for thread in l_thread:
	thread.join()

	



