import numpy as np
import cv2
from matplotlib import pyplot as plt
import sys
import os
import pdb
import random

def homography(src,dst,center_src, center_dst,r):

	height ,width = src.shape[:2]
	
	# Initiate SIFT detector
	sift = cv2.xfeatures2d.SIFT_create()

	# find the keypoints and descriptors with SIFT
	if r is None:
		kp1, des1 = sift.detectAndCompute(src,mask = None)
		kp2, des2 = sift.detectAndCompute(dst,mask = None)
	else:
		# compute the mask
		(x1,y1) = center_src
		M1 = np.zeros((height,width))
		cv2.circle(M1,(int(x1),int(y1)),r,(255,255,255),-1)
		M1 = np.uint8(M1)
	
		(x2,y2) = center_dst
		M2 = np.zeros((height,width))
		cv2.circle(M2,(int(x2),int(y2)),r,(255,255,255),-1)
		M2 = np.uint8(M2)

		kp1, des1 = sift.detectAndCompute(src,mask = M1)
		kp2, des2 = sift.detectAndCompute(dst,mask = M2)
	if len(kp1) < 100 or len(kp2) < 100 :
		if r is None:
			return None
		if r < 300:
			return homography(src,dst,center_src, center_dst,r+50)
		else:
			return homography(src,dst,center_src, center_dst,None)
	else:
		FLANN_INDEX_KDTREE = 1
		index_params = dict(algorithm = FLANN_INDEX_KDTREE, trees = 5)
		search_params = dict(checks = 50)
		flann = cv2.FlannBasedMatcher(index_params, search_params)
		if (des1 is None or des2 is None):
			if r is None:
				return None
			if r < 300:
				return homography(src,dst,center_src, center_dst,r+50)
			else:
				return homography(src,dst,center_src, center_dst,None)
		else:	
			matches = flann.knnMatch(des1,des2,k=2)
			# store all the good matches as per Lowe's ratio test.
			good = []
			for m,n in matches:
			    if m.distance < 0.8*n.distance:
				good.append(m)
		
			# compute the transformation matrix
		
			src_pts = np.float32([kp1[m.queryIdx].pt for m in good ]).reshape(-1,1,2)
			dst_pts = np.float32([kp2[m.trainIdx].pt for m in good ]).reshape(-1,1,2)
			M, mask = cv2.findHomography(src_pts, dst_pts, cv2.RANSAC,5.0)
			if M is None :
				if r is None:
					return None
				if r < 300:
					return homography(src,dst,center_src, center_dst,r+50)
				else:
					return homography(src,dst,center_src, center_dst,None)
			
 		
	return M

def compute_norm_fixation(x,y,M):
	l = [x, y, 1]
	homog_coor = np.asarray(l)
	new_homoh_coor = M.dot(homog_coor)
	cart = [new_homoh_coor.item(0)/new_homoh_coor.item(2),new_homoh_coor.item(1)/new_homoh_coor.item(2)]
	return (cart[0],cart[1])

def generate_image(dossier,dossier_save):

	# store the fixation of the annotated segment
	fichier = open(dossier + "/annotation.txt","r")
	l0 = [0,0,0,0]
	l_fix = []
	while l0[1] != '1':
		l0 = fichier.readline().split()	

	while l0[1] != '0':
		l_fix.append(l0)
		l0 = fichier.readline().split()

	l_last = []
	for line in fichier:
		l_last.append(line.split())
	
	
	fichier.close()

	# open the data et coordinates files
	f_data = open(dossier_save + '/homographies_mid.txt','w')
	f_coor = open(dossier_save + '/coordinates_mid.txt','w')
		

	# get the middle image as the destination and draw its fixation
	ind_mid = int(len(l_fix)/2)-1
	l0 = l_fix[ind_mid]
	l_dst = l0
	img_ref = cv2.imread(dossier + '/Frames/' + l0[0] + '.jpg',0)
	img_dst = img_ref
	img0 = cv2.cvtColor(img_ref,cv2.COLOR_GRAY2RGB)
	width, height = img0.shape[:2]
	img0 = cv2.circle(img0,(int(l0[2]),int(l0[3])),5,(0,int((ind_mid*1.0/len(l_fix)*1.0)*255),255),-1)

	# compute the normalized fixations for the previous frames
	M = np.eye(3,3)
	data = []
	coord = []
	for k in range(ind_mid-1,-1,-1):

		l_src = l_fix[k]
		img_src = cv2.imread(dossier + '/Frames/' + l_src[0] + '.jpg',0)
		img_src = cv2.cvtColor(img_src,cv2.COLOR_GRAY2RGB)

		# compute the corresponding homography
		Mk = homography(img_src,img_dst,(float(l_src[2]),float(l_src[3])),(float(l_dst[2]),float(l_dst[3])),100)
		if Mk is not None:
			M = Mk.dot(M)

			# project the fixation point 
			(x_res, y_res) = compute_norm_fixation(float(l_src[2]),float(l_src[3]),M)

			# draw it on the middle image
			img0 = cv2.circle(img0,(int(x_res),int(y_res)),5,(0,int((k*1.0/len(l_fix)*1.0)*255),255),-1)

			# save the homography and the coordinates
			val = [Mk.item(k) for k in range(9)]
			data.append(str(val) + '\n')
			coord.append((x_res, y_res))
			
			# go on to the next frame
			img_dst = img_src
			l_dst = l_src
		else :
			data.append('[]\n')

	# write the homographies
	data = data[::-1]
	for d in data:
		f_data.write(d)

	# write the coordinates
	coord = coord[::-1]
	for c in coord:
		f_coor.write(str(c[1]) + ' ' + str(c[0]) + '\n')
	f_coor.write(l0[2] + ' ' + l0[3])


	# compute the normalized fixations for the next frames
	M = np.eye(3,3)
	img_dst = img_ref
	l_dst = l0
	for k in range(ind_mid+1,len(l_fix)):

		l_src = l_fix[k]
		img_src = cv2.imread(dossier + '/Frames/' + l_src[0] + '.jpg',0)
		img_src = cv2.cvtColor(img_src,cv2.COLOR_GRAY2RGB)

		# get the corresponding homography
		Mk = homography(img_src,img_dst,(float(l_src[2]),float(l_src[3])),(float(l_dst[2]),float(l_dst[3])),100)
		if Mk is not None:
			M = M.dot(Mk)

			# project the fixation point 
			(x_res, y_res) = compute_norm_fixation(float(l_src[2]),float(l_src[3]),M)

			# draw it on the middle image
			img0 = cv2.circle(img0,(int(x_res),int(y_res)),5,(0,int((k*1.0/len(l_fix)*1.0)*255),255),-1)

			# write the homography and the coordinates
			M_inv = np.linalg.inv(Mk)
			val = [M_inv.item(k) for k in range(9)]
			f_data.write(str(val) + '\n')
			f_coor.write(str(y_res) + ' ' + str(x_res) + '\n')

			# go on to the next frame
			img_dst = img_src
			l_dst = l_src
		else:
			f_data.write('[]\n')

	f_data.close()
	f_coor.close()


	cv2.imwrite(dossier_save + '/normalisation.jpg',img0)



d_objets = [ f for  f in os.listdir('images/') if not os.path.isfile(os.path.join('.',f))]
for dossier in d_objets:
	d_instances = [ f for  f in os.listdir('images/' + dossier) if not os.path.isfile(os.path.join('.',f))]
	for inst in d_instances:
		print 'images/' + dossier + '/' + inst
		if not os.path.isfile('normalized_images/' + dossier + '/' + inst + '/normalisation.jpg'):
			generate_image('images/' + dossier + '/' + inst ,'normalized_images/' + dossier + '/' + inst )
		



