import numpy as np
import cv2
from matplotlib import pyplot as plt
import matplotlib.image as mpimg
import sys
import os
from scipy import stats


f_answer = open('annotation_objects.txt','w')
f_saved = open('annotation_objects_save.txt','r')

already_done = []
for line in f_saved:
	obj = line.split()[0]
	already_done.append(obj)
	f_answer.write(line)
f_saved.close()

l_inst = []
l_dir = []
objects = ['unknown']
d_objets = [ f for  f in os.listdir('normalized_images/') if not os.path.isfile(os.path.join('.',f))]
for dossier in d_objets:
	objects.append(dossier)
	objects.append(dossier.lower())
	d_instances = [ f for  f in os.listdir('normalized_images/' + dossier) if not os.path.isfile(os.path.join('.',f))]
	for inst in d_instances:
		l_inst.append(inst)
		l_dir.append(dossier)

nb_inst = len(l_inst)
nb_done = len(already_done)

for elt in already_done:
	n = l_inst.index(elt)
	l_inst.pop(n)
	l_dir.pop(n)

print nb_done
print nb_inst - len(l_inst)

perm = np.random.permutation(len(l_inst))

l_inst_shuf = []
l_dir_shuf = []

for k in perm:
	l_inst_shuf.append(l_inst[k])
	l_dir_shuf.append(l_dir[k])		


for k in range(len(l_inst_shuf)):

	# get the folder and instance
	dossier = l_dir_shuf[k]
	inst = l_inst_shuf[k]

	# store the fixation of the annotated segment
	fichier = open('images/' + dossier + '/' + inst + "/annotation.txt","r")
	l0 = [0,0,0,0]
	l_fix = []
	while l0[1] != '1':
		l0 = fichier.readline().split()	

	while l0[1] != '0':
		l_fix.append(l0)
		l0 = fichier.readline().split()
	
	
	fichier.close()

	# read the image and display it
	img = mpimg.imread('normalized_images/' + dossier + '/' + inst + '/normalisation.jpg')
	img2 = mpimg.imread('images/' + dossier + '/' + inst + '/Frames/' + l_fix[int(len(l_fix)/4)][0] + '.jpg')
	plt.figure()
	plt.imshow(img)
	plt.figure()
	plt.imshow(img2)
	plt.show(block = False)
	value = raw_input("Object Grasped ("+ str(nb_done)+ '/' + str(nb_inst)+ ') ? ')
	if value == "quit":
		f_answer.close()
		sys.exit()
	while value not in objects:
		value = raw_input("Object Grasped (" + str(nb_done)+ '/' + str(nb_inst) + ') ? ')
		if value == "quit":
			f_answer.close()
			sys.exit()
	f_answer.write(inst + ' ' + value + '\n')
	plt.close("all")
	nb_done = nb_done + 1

f_answer.close()
plt.show()



