# -*- coding: utf-8 -*-


import _init_paths
from fast_rcnn.train import get_training_roidb, train_net
from fast_rcnn.config import cfg, cfg_from_file, cfg_from_list, get_output_dir
from datasets.factory import get_imdb
import caffe
import argparse
import pprint
import numpy as np
import sys
import os
import cPickle

    
imdb = get_imdb('gitw_train')
#Set the bb name
imdb.set_bb_db('gitw_train_random')
print 'Loaded dataset `{:s}` for training'.format(imdb.name)
roidb = get_training_roidb(imdb)
cc=np.zeros(imdb.num_classes,)
for v in xrange(imdb.num_videos):    
    fg_frames=roidb[v]['frame_types'].ravel().nonzero()[0]    
    posFr=len(fg_frames)
    #We don't consider what happens after the last positive
    negFr=fg_frames[0]
    label=roidb[v]['label']
    cc[label]+=posFr
    cc[0]+=negFr

cc=cc/cc.sum()
#Now we have to compute the cost matrix    
CM=np.zeros((imdb.num_classes,imdb.num_classes),dtype=np.float32)
for c in xrange(imdb.num_classes):    
    CM[c,...]=1.0/cc[c]
    CM[c,c]=0

CM=CM/CM.max()
    
blob = caffe.proto.caffe_pb2.BlobProto()
blob.height, blob.width = CM.shape
blob.data.extend(CM.astype(float).flat)
binaryproto_file = open(os.path.join(imdb.cache_path,'CM.binaryproto'), 'wb' )
binaryproto_file.write(blob.SerializeToString())
binaryproto_file.close()