# --------------------------------------------------------
# CCNN 
# Copyright (c) 2015 [See LICENSE file for details]
# Written by Deepak Pathak, Philipp Krahenbuhl
# --------------------------------------------------------
import pdb
import caffe
#import ccnn
from fast_rcnn.config import cfg
import numpy as np
from time import time
from ccnn import constraintloss
import sklearn.metrics as sklm
        
class WeakLossLayer(caffe.Layer):
    def DS(self, I, stride=32, factor=32,N=21):
        r = np.zeros(( (I.shape[0]-1)/stride+1, (I.shape[1]-1)/stride+1 ), dtype=I.dtype)
        for j in range(0,I.shape[0],stride):
            for i in range(0,I.shape[1],stride):
                p = I[j:j+factor,i:i+factor]
                b = np.bincount( p[p>=0],minlength=N )
                r[j/stride,i/stride] = np.argmax(b)
        return r

    def setup(self,bottom,top):
        self.bg_lower,self.bg_upper = 0.3,0.7
        self.bg_slack = 1e10 		# no slack : 1e10
        self.fg_lower_hard = 0.01
        self.fg_lower = 0.05
        self.fg_slack = 3.0 		# no slack : 1e10
        self.neg_upper = 0.01
        self.hardness = 1 				# no hardness : 1 and hardness : 1000

        self.semi_supervised = False
        self.apply_size_constraint = False
        self.normalization = False  # models/fcn_8s/solver_8s.prototxt needs the loss to be normalized and solver_32s doesn't
        
        #Reading parameters from the net definition
        params = eval(self.param_str)
        for k in iter(params.keys()):
            setattr(self,k,np.float(params[k]))
       
        if self.apply_size_constraint:
            self.bg_lower,self.bg_upper = 0.2,0.7
            self.bg_slack = 1e10
            self.fg_lower_hard = 0.1
            self.fg_lower = 0.1
            self.fg_slack = 1e10
            self.hardness = 1000
            self.fg_upper_small = 0.01 		# upper bound on small object. Don't make it zero as strictly less than 0 is not satisfiable. Make it epsilon small.
		
		# self.counter = 1

    
	
    def forward(self, bottom, top):
        
        
        t0 = time()
        D = bottom[0].channels
        N = bottom[0].num
        self.diff = []
        loss,w = 0,0
        
        # print '-------------------------------------'
        # print 'Image Number : ',self.counter 

        if self.semi_supervised:
            assert (len(bottom)>4),"Semi Supervised Flag ON, but full supervised images not supplied as additional bottom !"

        if (not self.semi_supervised) or (bottom[3].data==0): 		# weakly-supervised downsampled training
            # Setup bottoms
            f = np.ascontiguousarray(bottom[0].data)#np.ascontiguousarray(bottom[0].data.reshape((D,-1)).T) 		# f : height*width x channels
            q = np.exp(f-np.max(f,axis=1)[:,None]) #q is the output of the CNN	
            q/= np.sum(q,axis=1)[:,None]	# expAndNormalize across channels
            
            # Setup the constraint softmax
            csm = constraintloss.ConstraintSoftmax(self.hardness)
            
            # Compute Labels
            if self.apply_size_constraint:
                L = bottom[2].data.flatten() > 0.5
            else:
                L = np.zeros((D,),dtype=np.bool_)
                L[bottom[1].data.astype(np.int)] = 1 
            
             
            #Set the background to positive
            L[0]=1
            
            #Add Negative Label constraints
            #csm.addZeroConstraint( (~L).astype(np.float32) )
            for l in np.flatnonzero(~L): #We loop over the negatives
                if l>0: 	#We avoid the background class
                    v = np.zeros(D).astype(np.float32); v[l] = 1 #Array all zeroes but the selected category
                    w = bottom[2].data
                    csm.addLinearConstraint( -v,w,-self.neg_upper, self.fg_slack )

            # Apply Positive Label Constraints
            for l in np.flatnonzero(L): #We loop over the positives
                if l>0: 	#We avoid the background class
                    v = np.zeros(D).astype(np.float32); v[l] = 1 #Array all zeroes but the selected category
                    w = bottom[2].data
                    # if self.apply_size_constraint:
                        # 	csm.addLinearConstraint(  v, self.fg_lower_hard )
                    csm.addLinearConstraint(  v, w,self.fg_lower, self.fg_slack ) #We add a lower bound
														

            # Add Background Constraints (both lower and upper bounds)
            v = np.zeros(D).astype(np.float32); v[0] = 1
            #The weight for the BG lower is ones as it affects to the whole sequence
            w = np.ones(N,dtype=np.float32)
            csm.addLinearConstraint(  v, w,self.bg_lower, self.bg_slack ) # lower bound
            if (np.sum(L[1:]) > 0): # i.e. image is not all background
                w = bottom[2].data
                csm.addLinearConstraint( -v,w,-self.bg_upper ) # upper bound
				
				
				
            # Run constrained optimization	
            p = csm.compute(f)
            if self.normalization:
                self.diff=((q-p).T.reshape(bottom[0].data.shape))/np.float32(f.shape[0])      # normalize by (f.shape[0])
            else:
                self.diff=q-p      # unnormalize
                
        
			# Debugging Code ---------
				# temp = 1
				# for l in np.flatnonzero(L_up):
				# 	if l>0 and not L[l]:
				# 		if p[:,l].sum() > self.fg_upper_small:
				# 			print 'Small Object Class Index=',temp,'  sumP=',p[:,l].sum(),'  sumQ=',q[:,l].sum()
				# 			print '\tP=',repr(p[:,l])
				# 			print '\tQ=',repr(q[:,l])
				# 	temp += 1
				# print ''
				# np.savez('./debug/debug_im'+str(self.counter)+'.npz', hardness=self.hardness, bg_lower = self.bg_lower, bg_upper=self.bg_upper, L=L, L_up=L_up, fg_lower = self.fg_lower, fg_slack=self.fg_slack, fg_upper_small=self.fg_upper_small, f=f,p=p,q=q )
				# self.counter += 1
				# -----------------------

        else: 		# fully-supervised upsample training
            f = np.ascontiguousarray(bottom[5].data.reshape((D,-1)).T) 		# f : height*width x channels
            q = np.exp(f-np.max(f,axis=1)[:,None]) 								# expAndNormalize across channels
            q/= np.sum(q,axis=1)[:,None]

            gt = bottom[4].data
				# print '\t q : ',q.shape
				# print '\t cnn_output_Shape : ',bottom[0].data[i].shape
				# print '\t gt_Shape : ',gt.shape
				# print '\t gt_resized_Shape : ', (np.float32(self.DS(np.uint8(gt[0,...])))).shape
            gt = np.uint8(gt[0,...]) 		# For downsampling the gt use this : self.DS(np.uint8(gt[0,...]))
            gt = np.ascontiguousarray(gt.reshape((1,-1)).T) 		# gt : height*width x 1
            gt = gt.squeeze()
            p = np.zeros(q.shape).astype(np.float32) 					# q,p,f : height*width x channels
            ind = np.where(gt!=255)
            p[ind,gt[ind]] = 1
            ind = np.where(gt==255)
            p[ind,:] = q[ind,:] 								# so that q-p=0 at this position because it is ignore label

            if self.normalization:	
                self.diff.append( ((q-p).T.reshape(bottom[5].data.shape))/np.float32(f.shape[0]) )      # normalize by (f.shape[0])
            else:
                self.diff.append((q-p).T.reshape(bottom[5].data.shape))

        if self.normalization:			
            loss += (np.sum(p*np.log(np.maximum(p,1e-10))) - np.sum(p*np.log(np.maximum(q,1e-10))))/np.float32(f.shape[0])    # normalize by (f.shape[0])
        else:
            loss += (np.sum(p*np.log(np.maximum(p,1e-10))) - np.sum(p*np.log(np.maximum(q,1e-10))))    # unnormalize
        w = bottom[2].data
        outs=(q.transpose()*w).sum(axis=1)
        outs[0]=0
        outs=np.argmax(outs)
        acc=sklm.accuracy_score(bottom[1].data, outs[...,None])
        
        #print( np.min(f), np.max(f) )
        #np.set_printoptions(linewidth=150)
        #print( L.astype(int) )				
        #print( np.bincount(np.argmax(f,axis=1),minlength=17) )
        #print ("Loss %.3f\n"%loss)
        
        
#print( np.sum(p[:,~L]), 'P', np.sum(p,axis=0).astype(int)[L], 'H', np.bincount(np.argmax(p,axis=1),minlength=L.size)[L] )
		#print( "===== %f ====="%(time()-t0) )
        top[0].data[0,0,0,0] = loss#/bottom[0].shape[1]
        top[1].data[0,0,0,0] = acc
        self.diff = np.array(self.diff)

    def backward(self, top, propagate_down, bottom):
        if (not self.semi_supervised) or (bottom[3].data==0):
            bottom[0].diff[...] = top[0].diff[0,0,0,0]*self.diff
        else:
            bottom[5].diff[...] = top[0].diff[0,0,0,0]*self.diff
        
    def reshape(self, bottom, top):
        top[0].reshape(1,1,1,1)
        top[1].reshape(1,1,1,1)

