#!/usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Created on Wed Jul  5 17:06:22 2017

@author: igdiaz
"""

# --------------------------------------------------------
# Fast R-CNN
# Copyright (c) 2015 Microsoft
# Licensed under The MIT License [see LICENSE for details]
# Written by Ross Girshick
# --------------------------------------------------------

"""The layer that implements Multiple Instance Learning by means of a 
    by means of a log-exponential mean.
"""

import caffe
from fast_rcnn.config import cfg
import numpy as np
from enum import Enum
import pdb

    

class MilBBLayer(caffe.Layer):
    """MIL layer used for training."""

    
    def setup(self, bottom, top):
        """Setup the MILLayer."""
        params = eval(self.param_str)
        self._gamma = np.float(params["gamma"])
        self._nBBs = params["nBBs"]
        self._numClass = bottom[0].data.shape[1]
        self._max_idx = []
        self._normalizer=0.0
        self._myeps=1e-30
        self.blobs.add_blob(1)
        self.blobs[0].reshape(self._nBBs,self._numClass)
        self.blobs[0].data[...]=0 
        
    def forward(self, bottom, top):
        
        """Get blobs and copy them into this layer's top blob vector."""
        numData=bottom[0].shape[0]
        if(len(bottom)<2):
            rois=np.zeros((numData,1),dtype=np.int)
        else:
            rois=bottom[1].data
        weights=np.exp(self.blobs[0].data)
        wnorm=weights.sum(axis=0)
        #print weights/wnorm
        numClass=bottom[0].shape[1]
        #Get the different number of frames
        nFr=np.int(rois[...,0].max()+1)
        #Initialize frs_score
        frs_score=np.zeros((nFr,numClass),dtype=np.float32)
        self._max_idx=np.zeros((nFr,numClass),dtype=np.uint16)
        for f in xrange(nFr):
           bb_idx=np.where(rois[...,0]==f)[0]
           bb_idx=bb_idx[0:self._nBBs]
           bbs_score=bottom[0].data[bb_idx,...]
           #Compute the exponential
           self._normalizer=bbs_score.max()
           bbs_score=weights*np.exp(self._gamma*(bbs_score-self._normalizer))+self._myeps
           frs_score[f,...]=(1.0/self._gamma)*np.log(bbs_score.sum(axis=0)/wnorm)+self._gamma*self._normalizer
           
        top[0].data[...]=frs_score
        

    def backward(self, top, propagate_down, bottom):
        numData=bottom[0].shape[0]
        if(len(bottom)<2):
            rois=np.zeros((numData,1),dtype=np.int)
        else:
            rois=bottom[1].data
        
        weights=np.exp(self.blobs[0].data)
        wnorm=weights.sum(axis=0)
        
        #Get the different number of frames
        nFr=np.int(rois[...,0].max()+1)
        for f in xrange(nFr):
           bb_idx=np.where(rois[...,0]==f)[0]
           bb_idx=bb_idx[0:self._nBBs]
           bbs_score=bottom[0].data[bb_idx,...]
           #Compute the exponential
           self._normalizer=bbs_score.max()
           bbs_score=weights*np.exp(self._gamma*(bbs_score-self._normalizer))+self._myeps
           #Check if its very small => We put wbbs_score.mean rather than wbbs_score.sum to increase the lr
           bottom[0].diff[bb_idx,...]= self._gamma*top[0].diff[f,...]*bbs_score/(bbs_score.sum(axis=0));
           #Update the diff of the parameters
           self.blobs[0].diff[...] += 1e4*self._nBBs*top[0].diff[f,...]*(bbs_score/bbs_score.sum(axis=0)-weights/wnorm)
        
    def reshape(self, bottom, top):
        # check input dimensions match
        # difference is shape of inputs
        #self.diff = np.zeros_like(bottom[0].data, dtype=np.float32)
        if(len(bottom)<2):
            nFr=1;
        else:
            nFr=np.maximum(np.int(bottom[1].data[...,0].max())+1,1)
        
        
        
        numClass=bottom[0].data.shape[1]
        self._max_idx=np.zeros(nFr,)
        # output size
        top[0].reshape(nFr,numClass)
        self.blobs[0].diff[...]=0
            
        

