// --------------------------------------------------------
// CCNN 
// Copyright (c) 2015 [See LICENSE file for details]
// Written by Deepak Pathak, Philipp Krähenbühl
// --------------------------------------------------------

#include "constraintsoftmax.h"
#include "optimization/fista.h"
#include "util/eigen.h"
#include <iostream>
#include <stdlib.h>
#include <stdio.h>

LinearConstraint::LinearConstraint( const VectorXf & a, const VectorXf & w, float b, float slack):a(a),w(w),b(b),slack(slack) {
}

float LinearConstraint::eval( const RMatrixXf & x ) const {
	// Return   \sum_i a*x_i - b
	
	std::cout << "Entra" << std::endl;
	return ((w.replicate(1,x.rows())*x)*a).array().sum()-b;
}

/*WeightedLinearConstraint::WeightedLinearConstraint( const VectorXf & a, const VectorXf & w, float b, float slack ):a(a),w(w),b(b),slack(slack) {
}
float WeightedLinearConstraint::eval( const RMatrixXf & x ) const {
	// Return   \sum_i a*x_i - b
	return ((w.replicate(1,x.rows())*x)*a).array().sum()-b;
}*/

// Performed across columns i.e. across channels
static RMatrixXf expAndNormalize( const RMatrixXf & m ) {
	VectorXf mx = m.rowwise().maxCoeff();
	RMatrixXf r = (m.colwise()-mx).array().exp();
	return r.array().colwise() / r.array().rowwise().sum();
}
static VectorXf logSumExp( const RMatrixXf & m ) {
	VectorXf mx = m.rowwise().maxCoeff();
	return mx.array() + (m.colwise()-mx).array().exp().rowwise().sum().log();
}

// scale_ : determines the hardness of optimization. In hard case, entropy term in KL divergence is zero.
// Alternate way to implement this is to scale the second cross entropy term in KL divergence by 1000 times !
ConstraintSoftmax::ConstraintSoftmax( float scale ):scale_(scale) {
}

void ConstraintSoftmax::addLinearConstraint( const VectorXf & a, const VectorXf & w, float b, float slack ) {
	linear_constraints_.push_back( LinearConstraint(a, w, b, slack) );
}
void ConstraintSoftmax::addZeroConstraint( const VectorXf & a ) {
	eassert( (a.array() >= 0).all() );
	if( zero_constraints_.size() )
		zero_constraints_.array() = zero_constraints_.array() || (a.array() > 0);
	else
		zero_constraints_ = a.array() > 0;
}
/*Main function*/
RMatrixXf ConstraintSoftmax::compute( const RMatrixXf & f ) const {
	return expAndNormalize( scale_*computeLog( f ) );
}
/*Compute things in log*/
RMatrixXf ConstraintSoftmax::computeLog( const RMatrixXf & f ) const {
	//std::cout << "Starting optimization" << std::endl;
	const int N = f.rows(), M = f.cols();
	// Special handling for zero constraints, let's remove all dimensions
	// that are constraint to 0
	int pM = M;
	RMatrixXf pf = f, P;
	std::vector<LinearConstraint> pc = linear_constraints_;
	//std::cout << "Before constraints" << std::endl;
	// Project onto the zero constraints
	if( zero_constraints_.size() ) {
		//We count the number of categories that appear (pM number of positive categories)
		pM = (zero_constraints_.array()==0).cast<int>().sum();
		//std::cout << "pM: " << pM << std::endl;
		//If we have one or less than one categories (all pixels belong to the same category)
		if( pM <= 1 ) {
			//the original prob for the positive categories
			RMatrixXf r = 1*f;
			for( int i=0; i<M; i++ )
				if( zero_constraints_[i]>0 )
					//-inf for the rest
					r.col(i).setConstant(-1e10);
			return r;
		}
		// Build the projection matrix
		P = RMatrixXf::Zero(M,pM);
		for( int i=0,k=0; i<M; i++ )
			//If the category i is present
			if( !zero_constraints_[i] )
				P(i,k++) = 1; //This is a shift matrix to generate a new one with just the positive categories
				
		// Project onto the matrix : Means remove the variables with zero equality constraints
		pf = pf * P; //This is the new matrix without the negative categories
		for(auto & c: pc){ //Loop of linear constraints
			c.a = P.transpose() * c.a; //Apply the constraints to the matrix P
		}
	}
	//std::cout << "After constraints" << std::endl;
	// Let's formulate the constraints as Ap >= b 		(with slack : Ap >= b - slack)
	// Then our objective is D(p||q) = \sum p log p - \sum p log q + l' (b - Ap)
	//                               = - H_p - \sum p pf - l' A p + lb
	//                  d/dp D(p||q) = log p + 1 + c - pf - A' l = 0
	//                             p = 1/Z exp(fp + A'l)
	//                             where l >= 0
	// The objective then simplifies to
	//                       D(p||q) = \sum p (fp + A'l) - log Z - \sum p pf + l' (b - Ap)
	//                               = -log Z + l' b
	
	//std::cout << "M " << M << " N " << N << " pM " << pM << " K " << pc.size() << std::endl;
	
	
	RMatrixXf A(pc.size(),pM); //kxpM
	RMatrixXf W(N,pc.size()); //Nxk
	VectorXf b(pc.size()), slack(pc.size());
	for( int i=0; i<(int)pc.size(); i++ ) {
		A.row(i) = pc[i].a.transpose(); 		// Normalize by spatial_dim (no change theoretically, for implementation stability)
		W.col(i) = pc[i].w /  pc[i].w.sum();
		b[i] = pc[i].b;
		slack[i] = pc[i].slack * N;					// Scale regularizer of slack according to spatial_dim
	}
	
	/*std::cout << "A" << std::endl;
	std::cout << A << std::endl;
	std::cout << "W" << std::endl;
	std::cout << W << std::endl;
	
	*/
	
	// Solve for the soft assignment to the latent variables
	// This function returns 
	//	g : Gradient vector for dual variables. Returned as function argument.
	//  return : objective value for dual optimization (which is to be minimized)
	//  l: is the value of lambda in the paper
	auto fun = [&](const VectorXf & l, VectorXf * g) -> double {
		RMatrixXf Ma;
		if( g ) {
			/*std::cout << pf << std::endl;
			std::cout << "pf " << pf.rows() << "," << pf.cols() << " l " << l.rows() << "," << l.cols() << " A " << A.rows() << "," << A.cols() << std::endl;
			std::cout << "W " << std::endl;
			std::cout << W << std::endl;
			std::cout << "l " << std::endl;
			std::cout << l.transpose() << std::endl;
			std::cout << "W*l " << std::endl;*/
			Ma=(W.array().rowwise() * l.transpose().array()).matrix();
			Ma = scale_*(pf + Ma*A);
			RMatrixXf p = expAndNormalize( Ma );
			*g =  (A.array() * (W.transpose() * p).array()).matrix().rowwise().sum() - b;
			return 1.0/scale_*logSumExp(Ma).sum() - l.dot(b);
		}
		else{
			Ma=(W.array().rowwise() * l.transpose().array()).matrix();
			return 1.0/scale_*logSumExp(scale_*(pf + Ma*A)).sum() - l.dot(b);
		}
		/*std::cout << "loss" << std::endl;
		std::cout << 1.0/scale_*logSumExp( scale_*(pf + Ma*A)).sum() - l.dot(b) << std::endl;
		char ch1;
		std::cin>>ch1;*/
		
	};
	auto proj = [&](const VectorXf & x)->VectorXf {
	/*	 if (x.array().maxCoeff() > 0) {
		 	std::cout<<"\nActive Dual before slack : "<<x.array().maxCoeff()<<"\n";
		 	std::cout<<"Scaled slack value : "<<slack.array().minCoeff()<<"  Input scale value : "<<(float)slack.array().minCoeff()/(float)N<<"  scale N : "<<N<<"\n";
		 }*/
		return x.array().max(0.f).min(slack.array()); 					// 0 <= dual variable <= slack
	};
	
	// Solve for the lagrangian dual to the constraint optimization
	// VectorXf l = fista( VectorXf::Zero(pc.size()), fun, proj );		// accelerated pgd : pgd + momentum
	bool converged = false;
	//std::cout << "Before PGD" << std::endl;
	VectorXf l = pgd( VectorXf::Zero(pc.size()), fun, proj, false, &converged );
	//std::cout << "After PGD" << std::endl;
	if(!converged)
		printf("Projected gradient descent didn't converge. The problem might not be satisfiable!\n");

	// Compute the 'labels'
	RMatrixXf Ma=(W.array().rowwise() * l.transpose().array()).matrix();
	RMatrixXf r = pf + Ma*A;
				
	// Construct the result
	if( zero_constraints_.size() ) {
		r = r * P.transpose();
		for( int i=0; i<M; i++ )
			if( zero_constraints_[i]>0 )
				r.col(i).setConstant(-1e10);
	}
	/*std::cout << r << std::endl;
	char ch1;
	std::cin>>ch1;*/
	return r;
}

