#!/usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Created on Tue May 16 16:39:21 2017

@author: igonzalez
"""

import sys
import os
sys.path.insert(0, 'python')

import caffe
caffe.set_mode_cpu()

import matplotlib.pyplot as plt
import numpy as np
import sklearn.metrics
dataDir='data'

plt.close('all')


solver = caffe.NesterovSolver('lstm_1_solver.prototxt')


tr_vidx = range(1,11);
tst_vidx = range(11,16);

users = range(1,16);
             
nepochs=50


batchSize=solver.net.blobs['data'].data.shape[0];
dataDim=solver.net.blobs['data'].data.shape[1];
blockSize=len(solver.net.params['lstm1'][2].data)/4;
solver.net.params['lstm1'][2].data[blockSize:2*blockSize-1]=5.0
blockSize=len(solver.net.params['lstm2'][2].data)/4;
solver.net.params['lstm2'][2].data[blockSize:2*blockSize-1]=5.0
solver.net.blobs['clip'].data[...] = 1


trDataFile ='tr_data.npz'
if os.path.exists(trDataFile):
    npzFile=np.load(trDataFile)
    init_epoch=npzFile['init_epoch']
    train_loss = npzFile['train_loss']
    train_acc = npzFile['train_acc']
    train_auc = npzFile['train_auc']
    test_loss = npzFile['test_loss']
    test_acc = npzFile['test_acc']
    test_auc = npzFile['test_auc']
else:
    init_epoch=0
    train_loss = np.zeros(nepochs)
    train_acc = np.zeros(nepochs)
    train_auc = np.zeros(nepochs)
    test_loss = np.zeros(nepochs)
    test_acc = np.zeros(nepochs)
    test_auc = np.zeros(nepochs)
    
modeltrFile ='nettr'
if os.path.exists(modeltrFile):
    solver.net.copy_from('nettr')
modeltsFile = 'nettst'
if os.path.exists(modeltsFile):
    solver.test_nets[0].copy_from('nettst')
                
#Computing normalization terms
meanData=np.zeros((1,1))
contMean=0;
print 'Computing normalizers' 
for v in tr_vidx:
        print 'norm video %d/%d' % (v,len(tr_vidx))
        for u in users:
            inFile = dataDir + '/%d-%d.npy' % (v, u)     
            if os.path.exists(inFile):
                data=np.load(inFile);
                numData = data.shape[0];
                data=data[:,0:-1]
                input=np.zeros((numData,dataDim));
                #Spatial locations              
                mvx=data[:,0]-np.hstack((0,data[0:-1,0]))
                mvy=data[:,1]-np.hstack((0,data[0:-1,1]))
                input[:,0]=np.linalg.norm(np.transpose(np.vstack((mvx,mvy))),axis=1)
                meanData+=input.sum(axis=0);
                contMean+=numData;             

meanData=meanData/contMean;

for epoch in range(init_epoch,nepochs) :
    print "Starting epoch %d/%d" % (epoch,nepochs)
    #Loop of videos and users
    #Read the data
    contBatches = 0;
    contBatchesAUC=0;
    for v in tr_vidx:
        print 'train video %d/%d' % (v,len(tr_vidx))
        for u in users:
            inFile = dataDir + '/%d-%d.npy' % (v, u)     
            if os.path.exists(inFile):
                data=np.load(inFile);
                numData = data.shape[0];
                numBatchesVideo=int(numData / batchSize);
                for batch in range(numBatchesVideo) :
                    solver.net.blobs['clip'].data[0] = batch > 0                
                    auxData=np.float32(data[ batch * batchSize : (batch+1) * batchSize,:])                                    
                    mvx=auxData[:,0]-np.hstack((0,auxData[0:-1,0]))
                    mvy=auxData[:,1]-np.hstack((0,auxData[0:-1,1]))
                    solver.net.blobs['data'].data[:,0,0]=np.linalg.norm(np.transpose(np.vstack((mvx,mvy))),axis=1)-meanData[0]
                    labels = auxData[:,2:3]
                    labels = ((labels == 0) | (labels == 2)).astype(int)
                    solver.net.blobs['label'].data[...] = np.float32(labels)
                    solver.step(1)
                    train_loss[epoch] += solver.net.blobs['loss'].data
                    train_acc[epoch] += solver.net.blobs['accuracy'].data
                    if (int(any(labels==0)) + int(any(labels==1))) ==2 :
                        auc=sklearn.metrics.roc_auc_score(labels,solver.net.blobs['ip1'].data[:,1]);
                        contBatchesAUC+=1;
                    else:
                        auc=0
                    #print np.histogram(labels,2)[0]                                 
                    train_auc[epoch]+=auc
                    #print "Loss %f Accuracy %f AUC %f" % (solver.net.blobs['loss'].data,solver.net.blobs['accuracy'].data,auc)
                    
                    solver.net.blobs['ip1'].data.shape
                    contBatches+=1
    train_loss[epoch]=train_loss[epoch]/contBatches
    train_acc[epoch]=train_acc[epoch]/contBatches                
    train_auc[epoch]=train_auc[epoch]/contBatchesAUC
    print "======================================="
    print "End of epoch %d/%d" % (epoch,nepochs)
    print "Train Stats: Loss %f Accuracy %f AUC %f" % (train_loss[epoch],train_acc[epoch],train_auc[epoch])
    print "======================================="                          
    plt.figure(1)
    plt.plot(np.arange(epoch), train_loss[0:epoch],label='Loss')
    plt.plot(np.arange(epoch), train_acc[0:epoch],label='Acc')
    plt.plot(np.arange(epoch), train_auc[0:epoch],label='AUC')
    #plt.legend(handles=[line_Loss, line_Acc,line_AUC])
    plt.legend(bbox_to_anchor=(1.05, 1), loc=2, borderaxespad=0.)
    plt.show()



    #Now it is time to evaluate the test set
    contBatches = 0;
    contBatchesAUC=0;
    solver.test_nets[0].share_with(solver.net)
    solver.test_nets[0].blobs['clip'].data[...] = 1
    for v in tst_vidx:
        print 'test video %d/%d' % (v,len(tst_vidx))
        for u in users:
            inFile = dataDir + '/%d-%d.npy' % (v, u)     
            if os.path.exists(inFile):
                data=np.load(inFile);
                numData = data.shape[0];
                numBatchesVideo=int(numData / batchSize);
                for batch in range(numBatchesVideo) :
                    solver.test_nets[0].blobs['clip'].data[0] = batch > 0                
                    auxData=np.float32(data[ batch * batchSize : (batch+1) * batchSize,:])                                    
                    mvx=auxData[:,0]-np.hstack((0,auxData[0:-1,0]))
                    mvy=auxData[:,1]-np.hstack((0,auxData[0:-1,1]))
                    solver.test_nets[0].blobs['data'].data[:,0,0]=np.linalg.norm(np.transpose(np.vstack((mvx,mvy))),axis=1)-meanData[0]
                    labels = auxData[:,2:3]
                    labels = ((labels == 0) | (labels == 2)).astype(int)
                    solver.test_nets[0].blobs['label'].data[...] = np.float32(labels)
                    solver.test_nets[0].forward()
                    test_loss[epoch] += solver.test_nets[0].blobs['loss'].data
                    test_acc[epoch] += solver.test_nets[0].blobs['accuracy'].data
                    if (int(any(labels==0)) + int(any(labels==1))) ==2 :
                        auc=sklearn.metrics.roc_auc_score(labels,solver.test_nets[0].blobs['ip1'].data[:,1]);
                        contBatchesAUC+=1;
                    else:
                        auc=0
                    #print np.histogram(labels,2)[0]                                 
                    test_auc[epoch]+=auc
                    #print "Loss %f Accuracy %f AUC %f" % (solver.net.blobs['loss'].data,solver.net.blobs['accuracy'].data,auc)
                    
                    contBatches+=1
    test_loss[epoch]=test_loss[epoch]/contBatches
    test_acc[epoch]=test_acc[epoch]/contBatches                
    test_auc[epoch]=test_auc[epoch]/contBatchesAUC
    print "======================================="
    print "End of epoch %d/%d" % (epoch,nepochs)
    print "Test Stats: Loss %f Accuracy %f AUC %f" % (test_loss[epoch],test_acc[epoch],test_auc[epoch])
    print "======================================="                                   
    plt.figure(2)
    plt.plot(np.arange(epoch),test_loss[0:epoch],label='Loss')
    plt.plot(np.arange(epoch), test_acc[0:epoch],label='Acc')
    plt.plot(np.arange(epoch), test_auc[0:epoch],label='AUC')
    #plt.legend(handles=[line_Loss, line_Acc,line_AUC])
    plt.legend(bbox_to_anchor=(1.05, 1), loc=2, borderaxespad=0.)
    solver.net.save('nettr')
    solver.test_nets[0].save('nettst')
    #Save data for the training phase
    trDataFile ='tr_data.npz'
    np.savez(trDataFile,init_epoch=epoch,train_loss=train_loss,train_acc=train_acc,train_auc=train_auc,test_loss=test_loss,test_acc=test_acc,test_auc=test_auc);
            
    
    
        
