#!/usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Created on Tue May 16 15:24:23 2017

@author: igonzalez
"""

import sys
import os
import numpy as np

sys.path.insert(0, 'python')

outDir='data'
if not os.path.exists(outDir):
    os.makedirs(outDir)
    

baseDir = '/export/data_gpm/public/databases/CRCNS-DataShare'
stemFile = baseDir + '/stemlist.txt';
userFile = baseDir + '/subjectlist.txt';

with open(stemFile, 'r') as f:
    videos = f.read().splitlines()

with open(userFile, 'r') as f:
    users = f.read().splitlines()

 
#Loop of videos
for idxv, video in enumerate(videos):
    for idxu, user in enumerate(users):        
        inFile = baseDir + '/' + user + '/' + video + '.e-ceyeS'
        #If the file exists, we read the data
        if os.path.exists(inFile):
            outFile = outDir + '/%d-%d.npy' % (idxv+1, idxu+1)     
            print 'Computing' + outFile
            with open(inFile, 'r') as f:
                data = f.read().splitlines()
            reject = int(data[2].split()[2]);
            
            #Now the loop over the data
            initLine = reject+3
            numData = len(data)-initLine
            fixMatrix =  np.zeros((numData,3),'float')            
            for lineidx in range(0,numData):
                fixdata = data[lineidx + initLine].split()
                fixMatrix[lineidx][0] = float(fixdata[0])
                fixMatrix[lineidx][1] = float(fixdata[1])
                fixMatrix[lineidx][2] = float(fixdata[3])
            np.save(outFile,fixMatrix)