## Code for Constrained Convolutional Neural Networks to gaze-driven active object recognition

### Contents
1. [Code description](#1-code-description)
2. [Compilation](#2-compilation)
3. [Usage](#3-usage)



### 1) Code description 

#Main code of the implemented blocks (lib_fast_rcnn and lib)

The code involves several processing blocks that are contained in the 'lib_fast_rcnn' folder:

1. fast_rcnn: contains the train and test python scripts.
2. datasets: grasping_in_the_wild.py controls the access to the dataset
3. roi_data_layer: controls the data layer and allows reading images and ROIs (region of interest)
4. mil_layer: implements the MIL layer used to fuse bb detections and generate frame-level vectors 
5. weak_loss_layer: contains the code associated to the weak_loss_layer (which is complented by the c++ code contained in the folder lib)
6. utils: some utilities

#Caffe code (caffe-ccnn)
The version of caffe used in this code incorporates some extra modules and is included in folder 'caffe-ccnn'

#Network Models (models)
The models defining the networks are contained in the folder models. We have models for alexnet (caffenet), and resnet-50. 

#ImageNet initialization models and other data (data)
In data folder our approach stores temporal information for fast cache access such as the ROIs and the image_net models with the weights (they are not included in the svn due to their large size).

### 2) Compilation

1. Build Caffe
	``` Shell
	    cd caffe-cnn
		make all
		make pycaffe
		cd ..
	```
2. Build weak loss 

    ```Shell
    mkdir build
    cd build
    cmake ..
    cd ..
    make
    ```
    
### 3) Usage

Experiments are organized as follows:
1. In experiments/cfgs we store the configuration of the experiments
2. In experiments/scripts we have the scripts to be called in the experiments.
3. In outputs we store the results of the experiment
 
**Train** CCNN.

```Shell
cd ccnn
bash python experiments/scripts/resnet-50_weak.sh 0   # 0 is the gpu-id
```

**Test** CCNN.

```Shell
cd ccnn
python experiments/scripts/resnet-50_test_weak.sh 0 40000  # 0 is the gpu-id, 40000 is the iteration to be used
```

