#!/usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Created on Wed Jun 28 15:54:44 2017

@author: igdiaz
"""

import os
import pdb
import numpy as np
import glob

dbOrigDir= '/net/incia/Data/Datasets/grasping_in_the_wild/packaging';
dbAnnDir='/net/incia/Data/Datasets/grasping_in_the_wild/new_annotation';
dbDir='/data/incia/Data/Datasets/GITW';

dbImagesDir=os.path.join(dbDir,'images');
dbSetsDir=os.path.join(dbDir,'ImageSets');
dbBBsDir=os.path.join(dbDir,'BBs');

#Blocks to be executed
active_blocks=[0, 0, 0, 1]

#Properties of frame extraction
extract_frames=False
scale_reduction=2

#Properties of data splitting
split_type=1 #0 by Loc, 1 by Subject

#Best solution up to date
#scales=[75, 125, 200]
#aspect_ratios=[0.8, 1, 1.25]
#angles=[-45, -30, -20, -10, 10, 20, 30, 45]

#Properties of BBs and data augmentation
scales=[75, 125, 200]
aspect_ratios=[0.8, 1, 1.25]
angles=[]#[-45, -30, -20, -10, 10, 20, 30, 45]

methodBG=0
if len(angles)==0:
    annotationType=''
    methodBGstrs=['fix','random']
else:
    annotationType='_2'
    methodBGstrs=['fixaug','randomaug']
    
debugPatches=False
numCores=2

"""BLOCK 1: GENERATING THE DATASETS"""

if active_blocks[0]>0:
    from datasetGeneration import generateDataset
    #Generate the dataset
    db_properties=generateDataset(dbOrigDir,dbAnnDir,dbImagesDir,scale_reduction,extract_frames)
    dbpropsFile=os.path.join(dbDir,'db_properties.npy')
    print db_properties
    np.save(dbpropsFile,db_properties)
else:
    dbpropsFile=os.path.join(dbDir,'db_properties.npy')
    db_properties=np.load(dbpropsFile)

   
#Getting numbers
numCat=db_properties[0]
numPlaces=db_properties[1]
numSubjects=db_properties[2]
height=db_properties[3]
width=db_properties[4]

"""BLOCK 2: COMPUTING CATEGORIES AND STATS"""

if active_blocks[1]>0:
    
    print "%d cats %d places %d subjects"%(numCat,numPlaces,numSubjects)
    #Generate the categories list
    categories = sorted(os.listdir(dbImagesDir))
    numCat=len(categories) 
    catFile=os.path.join(dbDir,'categories.txt')
    cf = open(catFile, "w")
    for c in range(numCat):
        cf.write('%s\n'%categories[c])
    cf.close();
    
    #Generate the matrix that counts the subjects we have for each object and location
    subjects_by_cat_and_place=np.zeros((numCat,numPlaces),dtype=np.int)
    for c in range(numCat):
        for p in range(numPlaces):
            search_pattern=os.path.join(dbImagesDir,categories[c],'%sPlace%dSubject*'%(categories[c],(p+1)))
            subjects_by_cat_and_place[c,p] = len(glob.glob(search_pattern))
    
    statsFile=os.path.join(dbDir,'subjects_by_cat_and_place.npy')
    print subjects_by_cat_and_place
    np.save(statsFile,subjects_by_cat_and_place)
else:
    statsFile=os.path.join(dbDir,'subjects_by_cat_and_place.npy')
    subjects_by_cat_and_place=np.load(statsFile)
    catFile=os.path.join(dbDir,'categories.txt')
    cf = open(catFile, "r")
    categories=cf.read().splitlines();
    cf.close();
    numCat=len(categories)


"""BLOCK 3: SPLITTING THE DATASETS"""

if active_blocks[2]>0:
    from assignVideos import assignVideosbyLoc
    from assignVideos import assignVideosbySubject
    
    answer = raw_input("You are about to override the ImageSets with might be catastrofic. Are you sure? [y]/[n]: ")
    if answer == 'y': 
        print("So there we go...")
        
        #Assign videos by splitting in locations and categories
        #This avoids training and testing with the same object instances
        #The counterpart is that it is much more challenging
        if split_type==0:
            sets_assign=assignVideosbyLoc(subjects_by_cat_and_place)
        else:
            sets_assign=assignVideosbySubject(subjects_by_cat_and_place)
            
        if os.path.exists(dbSetsDir)==0:
            os.mkdir(dbSetsDir)
        
        #Generate the index files
        fullFile=os.path.join(dbSetsDir,'full.txt');
        ff=open(fullFile, "w") 
        trFile=os.path.join(dbSetsDir,'train.txt');
        tf=open(trFile, "w") 
        valFile=os.path.join(dbSetsDir,'val.txt');
        vf=open(valFile, "w") 
        tvalFile=os.path.join(dbSetsDir,'trainval.txt');
        #tvf=open(tvalFile, "w")
        tstFile=os.path.join(dbSetsDir,'test.txt');
        tsf=open(tstFile, "w")
        
        for c in range(numCat):
            for p in range(numPlaces):
                for s in range(numSubjects):
                    #If the video does not exist
                    if sets_assign[c,p,s]==0:
                        continue
                    
                    outs="%s/%sPlace%dSubject%d %d\n"%(categories[c],categories[c],p+1,s+1,c+1)
                    ff.write(outs) 
                    if sets_assign[c,p,s]==1:
                        tf.write(outs) #Train
                        #tvf.write(outs) #Trainval
                    elif sets_assign[c,p,s]==2:
                        vf.write(outs) #Val
                        #tvf.write(outs) #Trainval
                    elif sets_assign[c,p,s]==3:    
                        tsf.write(outs) #Test    
        
        ff.close()
        tf.close()
        vf.close()
        #tvf.close()                
        tsf.close()
        #Concat train and val to generate trainval
        os.system("cat " + trFile + " " + valFile + "  > " + tvalFile)
    else:
        print("OK. Avoiding any update")    

"""BLOCK 4: GENERATING CANDIDATE BOUNDING BOXES"""
if active_blocks[3]>0:
    from generateCandidateBoxes import generateCandidateBoxes
    if os.path.exists(dbBBsDir)==0:
        os.mkdir(dbBBsDir)
        
    datasets=['train','val'] #['train','val','test']
    for d in range(len(datasets)):
        boxes=generateCandidateBoxes(dbDir,datasets[d],scales,aspect_ratios,angles,[height,width],methodBG,annotationType,numCores,debugPatches)
        bbFile=os.path.join(dbBBsDir,'gitw_%s_%s%s.npy'%(datasets[d],methodBGstrs[methodBG],annotationType))
        np.save(bbFile,boxes)
  
    bbFile=os.path.join(dbBBsDir,'gitw_%s_%s%s.npy'%('train',methodBGstrs[methodBG],annotationType))
    boxes=np.load(bbFile)
    bbFile=os.path.join(dbBBsDir,'gitw_%s_%s%s.npy'%('val',methodBGstrs[methodBG],annotationType))
    val_data=np.load(bbFile)
    boxes=np.hstack((boxes,val_data))
    bbFile=os.path.join(dbBBsDir,'gitw_%s_%s%s.npy'%('trainval',methodBGstrs[methodBG],annotationType))
    np.save(bbFile,boxes)
    