#!/usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Created on Thu Jun 29 12:02:54 2017

@author: igdiaz
"""
import pdb
import os
import numpy as np
import numpy.random as npr
import pyximport
pyximport.install()
from bbox import bbox_overlaps
from PIL import Image
from PIL import ImageDraw
import glob
import cv2
import multiprocessing
from multiprocessing.pool import ThreadPool
import time    
    
"""Function that generates candidate bouding boxes
    bg_method affects of how we sample bg boxes:
        0: we only sample boxes on the fixations (bg boxes are extracted in non-valid frames)
        1: we sample bg boxes in every type of frame using random sampling
    if angles is a non-empty array, we do image-based data augmentation and create new images    
"""
def generateCandidateBoxes(dbDir,dbSet,scales,ratios,angles,imSize,bg_method,annotationType,numCores,saveImages=False):
    
    dbSetsDir=os.path.join(dbDir,'ImageSets');
    setFile=os.path.join(dbSetsDir,dbSet+'.txt');
    fc=open(setFile,'r')
    videos=fc.read().splitlines()
    fc.close()
    
    nVideos=len(videos)
    boxes = np.zeros((nVideos,), dtype=np.object)
    
    all_video_params=[]
    #Generate the struct of data
    for v in range(nVideos):
        video_params=VideoParamStruct()
        video_params.numVideo=v
        video_params.nVideos=nVideos
        video_params.videos=videos
        video_params.dbDir=dbDir
        video_params.dbSet=dbSet
        video_params.scales=scales
        video_params.ratios=ratios
        video_params.angles=angles
        video_params.imSize=imSize
        video_params.bg_method=bg_method
        video_params.annotationType=annotationType
        video_params.saveImages=saveImages
        all_video_params.append(video_params)

    if(numCores>1):
        pool = multiprocessing.Pool(processes=numCores)
        boxes=pool.map(processVideo,all_video_params)
        pool.close()
        pool.join()      
    else:
        for v in range(nVideos):
            boxes[v]=processVideo(all_video_params[v])
    
    
        
    return boxes

class VideoParamStruct:
    numVideo=0
    nVideos=0
    videos=[]
    dbDir=[]
    dbSet=[]
    scales=[]
    ratios=[]
    angles=[]
    imSize=[]
    bg_method=[]
    annotationType=[]
    saveImages=[]
    
def processVideo(video_params):     
    t = time.time()
    v=video_params.numVideo
    nVideos=video_params.nVideos
    videos=video_params.videos
    height=video_params.imSize[0]
    width=video_params.imSize[1]
    #We generate 5 times more BG boxes than FG
    propBg=5;
    
    dbImagesDir=os.path.join(video_params.dbDir,'images');
    
    dbCaptionsDir=os.path.join(video_params.dbDir,'masked');
        
    numScales=len(np.atleast_1d(video_params.scales))
    numRatios=len(np.atleast_1d(video_params.ratios))
    numAngles=len(np.atleast_1d(video_params.angles))
    numVariations=numScales*numRatios
    numAug=numAngles+1

    
    #To check if a video has valid frames
    vvalid=0
    #video=videos[v].split()[:-1]
    idx=videos[v].find(' ',len(videos[v])-3)
    video=videos[v][0:idx]
    
    print "%d/%d %s"%(v,nVideos,video)
    
    annFile=os.path.join(dbImagesDir,video,'annotation' + video_params.annotationType + '.txt')
    fc=open(annFile,'r')
    fr_data=fc.read().splitlines()
    fc.close()
    nFrames=len(fr_data)
    boxes = np.zeros((nFrames,), dtype=np.object)
    
    if(len(video_params.angles)>0):
        if os.path.exists(os.path.join(dbImagesDir,video,'FramesAug'))==0:
            os.makedirs(os.path.join(dbImagesDir,video,'FramesAug'))
    
    for f in range(nFrames):
        contBBs=0
        tdata=fr_data[f].split()
        
        if video_params.bg_method==0:
            boxes[f] = np.zeros((numAug,numVariations,5), dtype=np.uint16)
        elif video_params.bg_method==1:
            boxes[f] = np.zeros((numAug,(1+propBg)*numVariations,5), dtype=np.uint16)
        
        if(len(tdata)>4):
            valid=np.uint16(1.0/((np.maximum(np.float(tdata[4]),0.1)/np.maximum(height,width))));
        else:    
            valid=np.uint16(tdata[1])
        
        vvalid+=np.float(tdata[1])
        
        #Getting the fixations
        fx=np.uint16(tdata[2])
        fy=np.uint16(tdata[3])
        
        impath=os.path.join(dbImagesDir,video,'Frames',tdata[0]+'.jpg');
        if (valid and video_params.saveImages):
            imgs = Image.open(impath)
            draw = ImageDraw.Draw(imgs)
            
        """SAMPLING THE ORIGINAL IMAGE"""
        #Sampling the fixated bbs
        boxes[f][0,:numVariations,...]=sampleFixBoxes(valid,video_params.scales,video_params.ratios,(width,height),(fx,fy))
        #Sampling the bbs outside the fixation
        if video_params.bg_method>0:
            numBGBoxes=propBg*numVariations
            boxes[f][0,numVariations:,...],contBG=sampleNonFixBoxes(valid,video_params.bg_method,numBGBoxes,video_params.scales,video_params.ratios,(width,height),(fx,fy),boxes[f][0:numVariations,1:],(0,0))                        
        
            if contBG<numBGBoxes:
                print "Problem. We have not found bg boxes in 1000 iters"
                
            contBBs+=numBGBoxes
             
        """DATA AUGMENTATION"""
        if(len(video_params.angles)>0):
            img = cv2.imread(impath)
            
                
            for a in range(len(video_params.angles)):
                rimg,rf,vmask = rotateImageFix(img,(fx,fy),video_params.angles[a])
################################################
###############OJO BORRAR!!!!!!!################
################################################                
                #Save the image
                #if valid:
                #    imoutpath=os.path.join(dbImagesDir,video,'FramesAug',tdata[0]+'_v%d'%(a+1) +'.jpg');
                #    cv2.imwrite(imoutpath,rimg)
                
                #Sampling the fixated bbs
                boxes[f][a+1,:numVariations,...]=sampleFixBoxes(valid,video_params.scales,video_params.ratios,(width,height),rf,vmask)
                #Sampling the bbs outside the fixations => Very dangerous with data augmentation 
                if video_params.bg_method>0:
                    numBGBoxes=propBg*numVariations
                    boxes[f][a+1,numVariations:,...],contBG=sampleNonFixBoxes(valid,video_params.bg_method,numBGBoxes,video_params.scales,video_params.ratios,(width,height),rf,boxes[f][0:numVariations,1:],(0,0),vmask)                        
                    if contBG<numBGBoxes:
                        print "Problem. We have not found bg boxes in 1000 iters"
                        #boxes[v][f]=boxes[v][f][0:numVariationsPerAngle+contBG,...]
                           
        if valid and video_params.saveImages: 
            for s in range(numScales):
                for r in range(numRatios):
                    box=boxes[f][0,s*numRatios+r,...]
                    draw.rectangle((box[1],box[2],box[1]+box[3],box[2]+box[4]), fill=None, outline='red')
        
            if os.path.exists(os.path.join(dbCaptionsDir,video))==0:
                os.makedirs(os.path.join(dbCaptionsDir,video))
                
            outPath=os.path.join(dbCaptionsDir,video,tdata[0]+'.jpg')
            imgs.save(outPath)  
            
    if vvalid==0:
        print 'Error video %s has not positives frames'%video
    
    elapsed = time.time() - t
    #print "%.3f"%elapsed
                
    return boxes

#Sample Boxes on the fixations   
def sampleFixBoxes(valid,scales,ratios,imSize,fixation,vmask=None):
    numScales=len(scales)
    numRatios=len(ratios)
    numVariations=numScales*numRatios
    width=imSize[0]
    height=imSize[1]
    fx=fixation[0]
    fy=fixation[1]
    fx=min(fx,width-10)
    fy=min(fy,height-10)
    boxes=np.zeros((numVariations,5), dtype=np.uint16)
    #Sampling the foreground
    for s in range(numScales):
        for r in range(numRatios):
            wbb=int(scales[s]/np.sqrt(ratios[r]))
            hbb=int(scales[s]*np.sqrt(ratios[r]))
                
            owbb=wbb
            ohbb=hbb
            while 1:
                wbb=np.uint16(np.minimum(np.minimum(wbb,2*fx),2*(width-fx)-1))
                hbb=np.uint16(np.minimum(np.minimum(hbb,2*fy),2*(height-fy)-1))
                ix=np.uint16(fx-0.5*wbb)
                iy=np.uint16(fy-0.5*hbb)
                if(ix<0 or iy<0 or (ix+wbb)>=width or (iy+hbb)>=height):
                    pdb.set_trace()
                    print "Error wbb %d hbb %d"%(wbb,hbb)
                box=np.uint16([valid, ix,iy,wbb,hbb])
                #Check if the box is within the mask
                if vmask is not None:
                    bbvalid=vmask[iy,ix] and vmask[iy+hbb,ix] and vmask[iy,ix+wbb] and vmask[iy+hbb,ix+wbb]
                    if bbvalid==0 and wbb>(owbb/3) and hbb>(ohbb/3):
                        #print "Reducing the size of the mask"
                        #pdb.set_trace()
                        wbb=int(np.float(wbb)*0.9)
                        hbb=int(np.float(hbb)*0.9)
                    else:
                        break;
                else:
                    break;
                    
            boxes[s*numRatios+r,...]=box
    return boxes

#Sample boxes outside the fixations       
def sampleNonFixBoxes(valid,bg_method,numBGBoxes,scales,ratios,imSize,fixation,fg_boxes,borders,vmask=None):
    width=imSize[0]
    height=imSize[1]
    boxes=np.zeros((numBGBoxes,5), dtype=np.uint16)
   
    #Now sample random bg boxes
    if bg_method==1:
        iteration=0
        contBG=0
        while contBG<numBGBoxes and iteration<1000:
            iteration+=1
            #Randomly sampling scale and aspect ratio
            scale=npr.choice(scales)
            ratio=npr.choice(ratios)
            wbb=int(scale/np.sqrt(ratio))
            hbb=int(scale*np.sqrt(ratio))

            owbb=wbb
            ohbb=hbb
            #Randomly sample the center
            ix=int((width-wbb-borders[0])*npr.rand()+borders[0])
            iy=int((height-hbb-borders[1])*npr.rand()+borders[1])
            
            box=np.uint16([0, ix,iy,wbb,hbb])
            if (ix >= borders[0] and iy >= borders[1] and int(ix+wbb)<(width-borders[0]) and int(iy+hbb)<(height-borders[1]))==0:
                print "Error"
            
            #Computing overlap
            overlapping = bbox_overlaps(fg_boxes.astype(np.float),np.reshape(box[1:].astype(np.float),(1,4)))
            overlapping=overlapping.max()
            if overlapping<0.3: 
                #Check if the box is within the mask
                if vmask is not None:
                    bbvalid=vmask[iy,ix] and vmask[iy+hbb,ix] and vmask[iy,ix+wbb] and vmask[iy+hbb,ix+wbb]
                    if(bbvalid==1 or wbb>(owbb/3) or hbb>(ohbb/3)):
                        boxes[contBG,...]=box
                        contBG+=1
                else:
                    boxes[contBG,...]=box
                    contBG+=1
                    
    return boxes,contBG

#Function that implements the data_augmentation with rotations
def rotateImageFix(img,fix,angle):
    fixh=np.concatenate((np.array(fix),[1]))
    image_center =fix#tuple((img.shape[1]/2,img.shape[0]/2))
    rot_mat = cv2.getRotationMatrix2D(image_center,angle,1.0)
    rimg = cv2.warpAffine(img, rot_mat, img.shape[1::-1],flags=cv2.INTER_LINEAR)
    rfix=(rot_mat.dot(fixh)).astype(np.int)
    #Now we have to get the valid bb
    vmask = computeValidMask(rimg)
    return rimg,rfix,vmask

def computeValidMask(img):
    gray = cv2.cvtColor(img,cv2.COLOR_BGR2GRAY)
    #gray = cv2.medianBlur(gray,3)
    ret,mask = cv2.threshold(gray,1,255,cv2.THRESH_BINARY)
    kernel = np.ones((20,20),np.uint8)
    mask = cv2.morphologyEx(mask, cv2.MORPH_CLOSE, kernel,borderType=cv2.BORDER_CONSTANT,borderValue=0)
    kernel = np.ones((5,5),np.uint8)
    mask = cv2.erode(mask,kernel,iterations = 1,borderType=cv2.BORDER_REPLICATE)
    return mask

#Function the flips an image horizontally
def  flipImage(img,fix,vmask=None):
    
    rimg=cv2.flip(img,1)
    height, width, channels = img.shape
    fix[0] = width - fix[0] - 1
    fix[1] = height - fix[1] - 1
    if vmask is None:
    	return rimg, fix	
    else:
        vmask=cv2.flip(vmask,1)
	return rimg, fix, vmask
        
