#!/usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Created on Wed Aug  2 10:01:47 2017

@author: igdiaz
"""
import os
import pdb
import numpy as np
import glob
import sklearn.metrics as skm

def evaluateResults(scores,labels,classes_names):
    num_classes=len(classes_names)
    #Computing scores per_category
    aps=np.zeros(num_classes,)
    ypred=scores
    cm=skm.confusion_matrix(labels,ypred).astype(np.float)
    ncm=np.transpose( np.transpose(cm) / np.maximum(cm.astype(np.float).sum(axis=1),1e-40) )
    print 'Final results:'
    print '*****************'    
    for cat in xrange(num_classes):
        scores_cat=scores==cat
        labels_cat=(labels==cat).astype(np.float)
        if(labels_cat.sum()>0):
            aps[cat]=skm.average_precision_score(labels_cat,scores_cat)
        else:
            aps[cat]=0
        print '%25s:\tap: %.3f\tacc: %.3f'%(classes_names[cat],aps[cat],ncm[cat,cat])
    print '*****************'    
    print '%25s:\tap: %.3f\tacc: %.3f\tbacc: %.3f'%('Average',aps.mean(),cm.trace()/cm.sum(),ncm.trace()/ncm.sum())    
    print 'Confusion Matrix'
    print cm
    np.set_printoptions(precision=3,linewidth=150)
    print ncm
    
dbDir='/data/incia/Data/Datasets/GITW';
hAnnDir=os.path.join(dbDir,'human_annotations');
userName='Pierre'

catFile=os.path.join(dbDir,'categories.txt')
cf = open(catFile, "r")
categories=cf.read().splitlines();
cf.close();
numCat=len(categories)
classes = tuple(categories)
class_to_ind = dict(zip(classes, xrange(numCat)))
 
    
annFile=os.path.join(hAnnDir,'annotation_objects_' + userName + '.txt');
fc=open(annFile,'r')
videos=fc.read().splitlines()
fc.close()

        
nVideos=len(videos)

gt_labels=np.zeros(nVideos,)
outs=np.zeros(nVideos,)
for v in range(nVideos):
    data=videos[v].split()
    idx=data[0].find("Place")
    gt_cat=data[0][0:idx]
    gt_labels[v]=class_to_ind[gt_cat]
    try:
        outs[v]=class_to_ind[data[1]]    
    except:
        outs[v]=-1
    

evaluateResults(outs,gt_labels,classes)  


