#!/usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Created on Wed Jun 28 12:17:47 2017

@author: igdiaz
"""

import os
import json
import numpy as np
from scipy import interpolate
import skimage.io
import skimage.transform
import glob
import matplotlib.pyplot as plt 
import pdb

def generateDataset(dbDir,dbAnnDir,dbOutDir,scale_reduction = 2.0,extract_frames=True):
    
    offsetFr=0;
    numCat=0
    numPlace=0
    numSubject=0
    
    #Loop over categories
    categories = os.listdir(dbDir)
    
    for cat in categories:
        
        catDir=os.path.join(dbDir,cat)
        catAnnDir=os.path.join(dbAnnDir,cat)
        catOutDir=os.path.join(dbOutDir,cat)
        if os.path.isdir(catDir)==0:
            continue
        
        print "Processing category %s"%cat
        numCat+=1
        
        
        
    
        videos = os.listdir(catDir)#['SaucePanPlace6Subject4']#
        #if we have videos it is a real category
        if os.path.exists(catOutDir)==0 and len(videos)>0: 
            os.makedirs(catOutDir)
            
        for video in videos:
            
            videoDir=os.path.join(catDir,video)
            videoAnnDir=os.path.join(catAnnDir,video)
            videoOutDir=os.path.join(catOutDir,video)
          
            if os.path.isdir(videoDir)==0:
                continue
            
            #It is a good idea to get everything organize by place and subject
            videostr = str(video)
            posPlace=videostr.find("Place")
            posSubject=videostr.find("Subject")
            place_idx=int(video[posPlace+5:posSubject])
            subject_idx=int(video[posSubject+7:])
            numPlace=max(numPlace,place_idx)
            numSubject=max(numSubject,subject_idx)
            
            
            #OutputFile
            annotationFile=os.path.join(videoOutDir,'annotation.txt')
            if os.path.exists(annotationFile): 
                print "Video %s was already done"%video
                exampleFrame=os.path.join(videoOutDir,'Frames','Frame_0.jpg')
                im=skimage.io.imread(exampleFrame)
                height=im.shape[0]
                width=im.shape[1]
                continue
            
            if os.path.exists(videoOutDir)==0: 
                os.makedirs(videoOutDir)
            print "Processing video %s"%video
            
            
            #Extracting frames from the video file
            if extract_frames:
                import skvideo.io 
                

                framesOutDir=os.path.join(videoOutDir,'Frames')
                if os.path.exists(framesOutDir)==0: 
                    os.makedirs(framesOutDir)
                    
                videoFile=os.path.join(videoDir,video + '.mp4')
                if os.path.exists(videoFile)==0: 
                    print "Error: the video %s does not exist"%videoFile
                    continue
                
                frames = skvideo.io.vread(videoFile)
                nFrames=frames.shape[0]
                height=frames.shape[1]
                width=frames.shape[2]
                
                
                for fr in range(nFrames):
                    frt=fr*40
                    frame=skimage.transform.rescale(frames[fr,:,:,:],1.0/scale_reduction,1,None,0,True,True).astype('uint8')
                    skimage.io.imsave("%s/Frame_%d.jpg" % (framesOutDir,frt),frame)     # save frame as JPEG file
                    
                 
                height=height/scale_reduction;
                width=width/scale_reduction
            else:
                listFrames=glob.glob(os.path.join(videoOutDir,'Frames','Frame_*.jpg'))
                nFrames=len(listFrames)
                exampleFrame=os.path.join(videoOutDir,'Frames','Frame_0.jpg')
                im=skimage.io.imread(exampleFrame)
                height=im.shape[0]
                width=im.shape[1]
                
            #Let's get the fixation file
            jsonFile=os.path.join(videoDir,video + '.json')
            
            if os.path.exists(jsonFile)==0: 
                print "Error: No file %s"%jsonFile
                continue
            
            contFix=0;
            gazePoints=0
            
            #Count the gaze points
            with open(jsonFile) as f:
                #First count the number of gaze points
                for line in f:
                    data=json.loads(line)
                    if 'gp' in data and data['s']==0:
                        gazePoints+=1;
        
            #Read the gaze points
            start=0
            fixdata=np.zeros((gazePoints,3))                   
            with open(jsonFile) as f:           
                for line in f:
                    data=json.loads(line)
                    if 'gp' in data and data['s']==0:
                        fixdata[contFix,0]=data['ts']
                        fixdata[contFix,1]=data['gp'][0]
                        fixdata[contFix,2]=data['gp'][1]
                        contFix+=1;
                        
                    if 'vts' in data and data['s']==0:
                        if data['vts']==0:
                            start=data['ts']
            
            if start==0:
                print "Error, no vts=0 found"    
                
            #Now we need to interpolate in the frame instants
            #we apply an offset to match with the previously extracted frames
            #start=fixdata[0,0]+offsetFr*40000 #(frames at T=1/25Hz=40ms)
            fr_instants=np.arange(start,start+nFrames*40000,40000) #(frames at T=1/25Hz=40ms)
            
            #We need to interpolate the fixations in the fr_instants
            #Use splines interpolation
            tck = interpolate.splrep(fixdata[...,0], fixdata[...,1], s=0.00)
            xfr = interpolate.splev(fr_instants, tck, der=0)
            tck = interpolate.splrep(fixdata[...,0], fixdata[...,2], s=0.00)
            yfr = interpolate.splev(fr_instants, tck, der=0)
            
#            plt.close('all')
#            fig=plt.figure(1)
#            plt.plot(fixdata[...,0], fixdata[...,1], 'x', fr_instants, xfr,'b')
#            plt.legend(['Orig', 'Cubic Spline'])
#            plt.title('X Cubic-spline interpolation')
#            fig.savefig('X.png')
#            fig=plt.figure(2)
#            plt.plot(fixdata[...,0], fixdata[...,2], 'x', fr_instants, yfr,'b')
#            plt.legend(['Orig', 'Cubic Spline'])
#            plt.title('Y Cubic-spline interpolation')
#            fig.savefig('Y.png')
#            pdb.set_trace()
           
      
            #Generate the masked images useful for annotation
            fixations=np.zeros((nFrames,2),dtype=np.int)           
            for fr in range(nFrames):
                frt=fr*40 #(frames at T=1/25Hz=40ms)
                fixations[fr,0]=int(width*xfr[fr]);
                fixations[fr,1]=int(height*yfr[fr]);
                
            #Generate the final annotation (by the moment with the current annotations in bbFile)
            #BoundingBox File
            
            bbFile=os.path.join(videoAnnDir,'bounding_box.txt')
            if os.path.exists(bbFile)==0: 
                print "Error: No file %s"%bbFile
                continue
            bbf = open(bbFile, "r") 
            
            #Get the segment
            initf=0
            endf=0
            fr=0
            for line in bbf: 
                data = line.split()
                bb = np.array(data[1:], dtype='|S4')
                bb = bb.astype(np.float)
                #If the bounding box is 0 0 0 0, then we consider it as negative
                if np.sum(bb)>0:
                    if initf==0:
                        initf=fr
                    else:
                        endf=fr
                fr+=1
            bbf.close();
            
            #Open the AnnotationFile for writing (fixating + grasping the object)
            af = open(annotationFile, "w") 
            bbf = open(bbFile, "r") 
            fr=0
            for line in bbf: 
                data = line.split()
                bb = np.array(data[1:], dtype='|S4')
                bb = bb.astype(np.float)
                #If the bounding box is 0 0 0 0, then we consider it as negative
                if(fr>=initf and fr<=endf):
                    label=1
                else:
                    label=0
                outs="%s %d %d %d\n"%(data[0][0:-4],label,fixations[fr,0],fixations[fr,1])
                af.write(outs)
                fr+=1
                
            bbf.close();
            af.close()      
    return (numCat,numPlace,numSubject,height,width)
