#!/usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Created on Wed Jun 28 12:17:47 2017

@author: igdiaz
"""
import pdb
import numpy as np


#Sets: 0 no used, 1 train, 2 val, 3 test

def assignVideosbyLoc(subjects_by_cat_and_place):
    
    
    #Get the numbers
    numCat=subjects_by_cat_and_place.shape[0]
    numPlace=subjects_by_cat_and_place.shape[1]
    numSubjects=subjects_by_cat_and_place.flatten().max()
    
    set_idx=np.ones(numPlace,)
    set_idx[1]=2
    set_idx[2]=3
    sets_assign=np.zeros((numCat,numPlace,numSubjects),dtype=np.int)
    for c in range(numCat):
        #We need to know how many locations do we have in the numCat
        samples=subjects_by_cat_and_place[c,]
        nz_places=samples.ravel().nonzero()[0]
        nzps=nz_places.shape[0]
        if nzps<4:
            print "Error in category%d. Not enough places."%c
        
        #We shuffle the nz_places
        np.random.shuffle(nz_places)
        #Loop over the nz_places 
        for p in range(nzps):
            pidx=nz_places[p]
            #Loop over the subjects
            for s in range(numSubjects):
                if subjects_by_cat_and_place[c,pidx]>s:
                    try:
                        sets_assign[c,pidx,s]=set_idx[p]
                    except:
                       pdb.set_trace() 
    return sets_assign


def assignVideosbySubject(subjects_by_cat_and_place):
    
    
    #Get the numbers
    numCat=subjects_by_cat_and_place.shape[0]
    numPlace=subjects_by_cat_and_place.shape[1]
    numSubjects=subjects_by_cat_and_place.flatten().max()
    
   
    sets_assign=np.zeros((numCat,numPlace,numSubjects),dtype=np.int)
    for c in range(numCat):
        #We need to know how many locations do we have in the numCat
        samples=subjects_by_cat_and_place[c,]
        locs=[]#np.empty((1,),dtype=np.int)
        subjects=[]#np.empty((1,),dtype=np.int)
        for i in range (len(samples)):
            locs=np.concatenate((locs,i*np.ones((samples[i],),dtype=np.int)))
            subjects=np.concatenate((subjects,range(0,samples[i])))
         
        
        nzps=locs.shape[0]
        numTr=int(0.6*nzps)
        numVal=int(0.8*nzps)
        print "Videos split: train %d val %d test %d"%(numTr,numVal-numTr,nzps-numVal)
    
        nz_samples=range(nzps)
        if nzps<4:
            print "Error in category%d. Not enough subjects."%c
        
        #We shuffle the nz_samples
        np.random.shuffle(nz_samples)
        #Loop over the nz_samples 
        for p in range(nzps):
            pidx=nz_samples[p]
            loc=int(locs[pidx])
            subject=int(subjects[pidx])
            if p<numTr:
                sets_assign[c,loc,subject]=1
            elif p<numVal:
                sets_assign[c,loc,subject]=2
            else:
                sets_assign[c,loc,subject]=3
                    
    return sets_assign


def assignVideosMultipleSets(subjects_by_cat_and_place,numSets):
    
    
    #Get the numbers
    numCat=subjects_by_cat_and_place.shape[0]
    numPlace=subjects_by_cat_and_place.shape[1]
    numSubjects=subjects_by_cat_and_place.flatten().max()
    
   
    sets_assign=np.zeros((numCat,numPlace,numSubjects),dtype=np.int)
    for c in range(numCat):
        #We need to know how many locations do we have in the numCat
        samples=subjects_by_cat_and_place[c,]
        locs=[]#np.empty((1,),dtype=np.int)
        subjects=[]#np.empty((1,),dtype=np.int)
        for i in range (len(samples)):
            locs=np.concatenate((locs,i*np.ones((samples[i],),dtype=np.int)))
            subjects=np.concatenate((subjects,range(0,samples[i])))
         
        
        nzps=locs.shape[0]
        nz_samples=range(nzps)
        if nzps<4:
            print "Error in category%d. Not enough subjects."%c
        
        #We shuffle the nz_samples
        np.random.shuffle(nz_samples)
        #Loop over the nz_samples 
        for p in range(nzps):
            pidx=nz_samples[p]
            loc=int(locs[pidx])
            subject=int(subjects[pidx])
            sets_assign[c,loc,subject]=p%numSets
                    
    return sets_assign