#include <cstdio>
#include <cstring>
#include <iostream>
#include <cstdlib>

#include <curl/curl.h>
#include <opencv2/core/core.hpp>
#include <opencv2/highgui/highgui.hpp>

using namespace std;

class GoProManager {
    private:
        string _password;
        string _url;

        CURL* _curl;
        CURLcode _res;

    public:
        GoProManager();
        GoProManager(string url, string password);
        virtual ~GoProManager(){};

        int startcapture();
        int stopcapture();
        int startstream();
        int startAndSaveStream(string live);
        int stopstream();

        void init_curl();
        int process_request(int mode);
        void exit_curl();

};

GoProManager::GoProManager() {
}

GoProManager::GoProManager(string url, string password) {
    _url = url;
    _password = password;
}

void GoProManager::init_curl() {
    curl_global_init(CURL_GLOBAL_ALL);
}

int GoProManager::startcapture()
{
    string urlget;

    _curl = curl_easy_init();
    if (_curl)
    {
        urlget = _url + "SH?t=" + _password + "&p=%01";

        cout << "URL = "<< urlget<<endl;
        curl_easy_setopt(_curl, CURLOPT_URL, urlget.c_str());
        _res = curl_easy_perform(_curl);

        if (_res != CURLE_OK)
        {
            fprintf(stderr, "curl_easy_perform() failed: %s\n",
                    curl_easy_strerror(_res));
        }
        curl_easy_cleanup(_curl);
    }
    return 0;
}

int GoProManager::stopcapture()
{
    string urlget;

    _curl = curl_easy_init();
    if (_curl)
    {
        urlget = _url + "SH?t=" + _password + "&p=%00";

        cout << "URL = "<< urlget<<endl;
        curl_easy_setopt(_curl, CURLOPT_URL, urlget.c_str());
        _res = curl_easy_perform(_curl);

        if (_res != CURLE_OK)
        {
            fprintf(stderr, "curl_easy_perform() failed: %s\n",
                    curl_easy_strerror(_res));
        }
        curl_easy_cleanup(_curl);
    }
    return 0;
}

int GoProManager::startstream() {
    string urlget;

    _curl = curl_easy_init();
    if (_curl)
    {
        urlget = _url + "PV?t=" + _password + "&p=%02";

        cout << "URL = "<< urlget<<endl;
        curl_easy_setopt(_curl, CURLOPT_URL, urlget.c_str());
        _res = curl_easy_perform(_curl);

        if (_res != CURLE_OK)
        {
            fprintf(stderr, "curl_easy_perform() failed: %s\n",
                    curl_easy_strerror(_res));
        }
        curl_easy_cleanup(_curl);
    }
    return 0;
}


int GoProManager::startAndSaveStream(string live) { // live doit etre "http://10.5.5.9:8080/live/amba.m3u8"

  /* cvNamedWindow("Camera_Output", 1);    //Create window
    CvCapture* capture = cvCaptureFromCAM(CV_CAP_ANY);  //Capture using any camera connected to your system
    while(1){ //Create infinte loop for live streaming
 
        IplImage* frame = cvQueryFrame(capture); //Create image frames from capture
        cvShowImage("Camera_Output", frame);   //Show image frames on created window
        key = cvWaitKey(10);     //Capture Keyboard stroke
        if (char(key) == 27){
            break;      //If you hit ESC key loop will break.
        }
	cv
    }
    cvReleaseCapture(&capture); //Release capture.
    cvDestroyWindow("Camera_Output"); //Destroy Window
    
    
    
    return 0;*/

  //VideoCapture cap("C:/Users/SHERMAL/Desktop/SampleVideo.avi"); // open the video file for reading
  
  

  cv::VideoCapture cap(live); // open the video file for reading
    if ( !cap.isOpened() )  // if not success, exit program
    {
         cout << "Cannot open the video file" << endl;
         return -1;
    }

    //cap.set(CV_CAP_PROP_POS_MSEC, 300); //start the video at 300ms

    double fps = cap.get(CV_CAP_PROP_FPS); //get the frames per seconds of the video

     cout << "Frame per seconds : " << fps << endl;

    cv::namedWindow("MyVideo",CV_WINDOW_AUTOSIZE); //create a window called "MyVideo"
    int cpt = 1;
    while(1)
    {
      string name = "frames/" + to_string(cpt) + ".png";
      cv::Mat frame;
        bool bSuccess = cap.read(frame); // read a new frame from video

        if (!bSuccess) //if not success, break loop
        {
                        cout << "Cannot read the frame from video file" << endl;
                       break;
        }

        cv::imshow("MyVideo", frame); //show the frame in "MyVideo" window
	   cv::imwrite(name, frame);
        if(cv::waitKey(30) == 27) //wait for 'esc' key press for 30 ms. If 'esc' key is pressed, break loop
       {
                cout << "esc key is pressed by user" << endl; 
                break; 
       }
	cpt = cpt +1;
    }

    return 0;

}

int GoProManager::stopstream() {
    string urlget;

    _curl = curl_easy_init();
    if (_curl)
    {
        urlget = _url + "PV?t=" + _password + "&p=%01";

        cout << "URL = "<< urlget<<endl;
        curl_easy_setopt(_curl, CURLOPT_URL, urlget.c_str());
        _res = curl_easy_perform(_curl);

        if (_res != CURLE_OK)
        {
            fprintf(stderr, "curl_easy_perform() failed: %s\n",
                    curl_easy_strerror(_res));
        }
        curl_easy_cleanup(_curl);
    }
    return 0;
}

int GoProManager::process_request(int mode) {
    string urlget;

    _curl = curl_easy_init();
    if (_curl) {
        switch (mode) {
            case 1: // Change camera mode
                urlget = _url + "PW?t=" + _password + "&p=%02"; // ChangeMode
                break;
            case 2: // Start Capture
                urlget = _url + "SH?t=" + _password + "&p=%01"; // Start Capture
                break;
            case 3: // stop capture
                urlget = _url + "SH?t=" + _password + "&p=%00"; // Stop Capture
                break;
            default:
                cout << "invalid entry"<<endl;
                return 1;
        }
        cout << "URL = "<< urlget<<endl;
        curl_easy_setopt(_curl, CURLOPT_URL, urlget.c_str());
        _res = curl_easy_perform(_curl);

        if (_res != CURLE_OK) {
            fprintf(stderr, "curl_easy_perform() failed: %s\n",
            curl_easy_strerror(_res));
        }
        curl_easy_cleanup(_curl);
    }
    return 0;
}

void GoProManager::exit_curl() {
    curl_global_cleanup();
}

int main(void)
{
    int mode = 1;
    string myurl = "http://10.5.5.9/bacpac/";
	
	// Write down here the password of your Gopro camera
    string mypswd = "goprohero1";
	
    GoProManager mygopro(myurl, mypswd); // set URL & password

    mygopro.init_curl();
    while (mode > 0 && mode < 4) {
        cout << "1- Change mode" <<endl;
        cout << "2- Start Capture" << endl;
        cout << "3- Stop Capture"<< endl;
        cin >> mode;
        mygopro.process_request(mode);
    }
    mygopro.exit_curl();
    return 0 ;
}

