%% Cleanup
clear all;
clc;
close all;

%% TRAINING
% Load
TRAIN_DATA = load( 'Training_7.log.train' );%#Iters Seconds TrainingLoss LearningRate
TRAIN_ITER = TRAIN_DATA(:,1);
TRAIN_TIME = TRAIN_DATA(:,2);
TRAIN_LOSS = TRAIN_DATA(:,3);
TRAIN_LRAT = TRAIN_DATA(:,4);
clear DATA;

% Select a range of data
iter_size  = 20;
iter_begin = 0;
iter_end   = 30000;
iter_step  = 100;
% convert to indexes
id_begin = floor(iter_begin/iter_size)+1;
id_end   = floor(iter_end  /iter_size);
id_step  = floor(iter_step /iter_size);
IDX = id_begin : id_step : id_end;

TRAIN_ITER = TRAIN_ITER(IDX);
TRAIN_LOSS = TRAIN_LOSS(IDX);
TRAIN_LRAT = TRAIN_LRAT(IDX);

TRAIN_DATA = [TRAIN_ITER TRAIN_LOSS];
dlmwrite('training.txt',TRAIN_DATA,'delimiter',' ');

% Make the pretty plot
figure;
title('Training loss w.r.t. #iterations' );

[hAx,~] = plotyy( TRAIN_ITER, TRAIN_LOSS, TRAIN_ITER, TRAIN_LRAT );
xlabel('#iters');
ylabel(hAx(1),'Loss');
ylabel(hAx(2),'Learning Rate');
set(hAx(2), 'YLim', [0 0.005]);
set(hAx(1), 'XLim', [-1 +inf]);
set(hAx(2), 'XLim', [-1 +inf]);
legend( 'Loss', 'Learning Rate=0.001' );

%% VALIDATION
% Load
TEST_DATA = load( 'Training_7.log.test' );%#Iters Seconds TestAccuracy TestLoss
TEST_ITER = TEST_DATA(:,1);
TEST_TIME = TEST_DATA(:,2);
TEST_ACCU = TEST_DATA(:,3);
TEST_LOSS = TEST_DATA(:,4);
clear TEST_DATA;

% Select a range of data
iter_size  = 2000;
iter_begin = 0;
iter_end   = 30000;
iter_step  = 2000;
% convert to indexes
id_begin = floor(iter_begin/iter_size)+1;
id_end   = floor(iter_end  /iter_size)+1;
id_step  = floor(iter_step /iter_size);
IDX = id_begin : id_step : id_end;

TEST_ITER = TEST_ITER(IDX);
TEST_ACCU = TEST_ACCU(IDX);
TEST_LOSS = TEST_LOSS(IDX);


TEST_DATA = [TEST_ITER TEST_ACCU];
dlmwrite('validation.txt',TEST_DATA,'delimiter',' ');

% Make the pretty plot
figure;
title('Validation Accuracy w.r.t. #iterations' );

[hAx,~] = plotyy( TEST_ITER, TEST_ACCU, TEST_ITER, TEST_LOSS );
%plot( TEST_ITER(IDX), TEST_ACCU(IDX) );
xlabel('#iters');
%ylabel('Accuracy');
ylabel(hAx(1),'Accuracy');
ylabel(hAx(2),'Loss');
legend( 'Accuracy', 'Loss' );
