#include <traitement.hpp>
// TODO : see if all of these lib are usefull in this mg
#include <opencv2/core/utility.hpp>
#include <opencv2/highgui.hpp>
#include <opencv2/imgproc.hpp>
#include <iostream>
#include <stdexcept>


using namespace std;
using namespace cv;
using namespace cv::cuda;

void StereoMatch::compute(Mat left,Mat right,Mat* disp)
{
  // Load images + convert for stereo matching
  cvtColor(left, left, CV_BGR2GRAY);
  cvtColor(right, right, CV_BGR2GRAY);
  // GPU loading
  _leftGPU.upload(left);
  _rightGPU.upload(right);
  *disp = Mat(left.size(), CV_16S);
  _dispGPU = cuda::GpuMat(left.size(), CV_8U);
  try
  {
    _bm->compute(_leftGPU,_rightGPU,_dispGPU);
  }
  catch(exception e)
  {
    cout << "Out of memory, damn\n";
  }
  if(_flag & COLOR)
  {
    GpuMat dispColor;
    _dispColor = cuda::GpuMat(left.size(),CV_8UC4);
    cuda::drawColorDisp(_dispGPU,_dispColor,NDISP);
    _dispColor.download(*disp);
  }
  else
    _dispGPU.download(*disp);
}

StereoMatch::~StereoMatch()
{
  _leftGPU.release();
  _rightGPU.release();
  _dispGPU.release();
  _bm.release();
}

StereoMatch::StereoMatch(int flag)
{
  if(flag & STEREOBM)
  {
    _bm = cuda::createStereoBM(NDISP,WINSIZE);
    _bm->setPreFilterCap(20);//20
    _bm->setPreFilterSize(15);//15
    _bm->setTextureThreshold(8);
    _bm->setUniquenessRatio(4);
    _bm->setSpeckleWindowSize(0);
    _bm->setSpeckleRange(0);
    _bm->setMinDisparity(1);
    _flag=flag;
  }
  else if(flag & STEREOBELIEFPROPAGATION)
  {
    /*int ndisp, iters, levels;
    cuda::StereoBeliefPropagation::estimateRecommendedParams(leftImg.rows,leftImg.cols,ndisp,iters,levels);
    cout << "*** VARIABLES VALUES ***" << endl 
	 << "ndisp : "<< ndisp << endl
	 << "iters : "<< iters << endl
	 << "levels : " << levels << endl;*/
      
    _bp = cuda::createStereoBeliefPropagation(NDISP);
    _bp->setMaxDataTerm(25.0);
    _bp->setDataWeight(0.1);
    _bp->setMaxDiscTerm(15.0);
    _bp->setDiscSingleJump(1.0);
  }
  
  if(flag & BILATERALFILTER)
  {
    _filter = cuda::createDisparityBilateralFilter(NDISP,3,1);
  }
  _flag=flag;
}  

