#include <iostream>
#include <cstdio>
#include <vector>
#include <cstdlib>
#include <opencv2/highgui/highgui.hpp>
#include "capture.hpp"
#define FILENAME "FILESAVE-"

using namespace cv;
using namespace std;
using vCaptureIt = vector<Capture>::iterator;

void help() 
{ 
cout << "\n\tUsage: <FileName> <Video/cam 1> ... <Camera/vid N>\n\tIf you want to use file, don't name them without extension\n\n";
}

int main(int argc,char** argv)
{
  if (argc < 3) 
  {
    help();
    return EXIT_FAILURE;
  }
  vector<Capture> vCapture;
  unsigned short int nbInput=argc-2; // argv[0]=prog_name,,argv[1]=file_name
  unsigned int screenshotIt = 0;
  for(int i=2;i<argc;i++)
  {
    cout << "Chargement de : " << argv[i] << endl;
    string s=argv[i];
    // Capture construction check if s is an input video file or a webcam stream
    try
    {
      vCapture.push_back(Capture(i-2,s));
    }
    catch(exception& e)
    {
      cout << "Exception : "<< e.what() << "\n";
      return EXIT_FAILURE;
    }
  }
  while(1)
  {
    for(vCaptureIt it=vCapture.begin();it!=vCapture.end();it++)
    {
      if(!it->read())
	return EXIT_SUCCESS;
    }
    char c=(char) waitKey(10000000);
    if(c==' ')
    {
      for(vCaptureIt it=vCapture.begin();it!=vCapture.end();it++)
      {
	it->takeScreenshot(screenshotIt);
      }
      screenshotIt++;
    }
    if(c==27) 
      return EXIT_SUCCESS;
  }
}
