#include <opencv2/calib3d/calib3d.hpp>
#include <opencv2/highgui/highgui.hpp>
#include <opencv2/imgproc/imgproc.hpp>
#include <stdio.h>
#include <vector>
#include <string>
#include <iostream>
#include <algorithm>
#include <stdexcept>
#include <calib.hpp>

void usage()
{
  cout << "\nUsage : ./Calibration -w <Calibration_board_weight> -h <Calibration_board_height>\n"
       << "\t-sz <Square_size> -vids <Left_video> <Right_video>\n"
       << "\t [Option] -single <Single_camera_calibration> HIGHLY RECOMMENDED\n"
       << "\t [Option] -singleDiff <Left_camera_calibration> <Right_camera_calibration>\n"
       << "\t [Option] -zt <CALIB_ZERO_TANGENT_DIST> -p <CALIB_FIX_PRINCIPAL_POINT>\n"
       << "\t [Option] -u <Video_test_file_left> <Video_test_file_right>\n"
       << "\t [Output] stereo.yml\n"
       <<" \n";
}

int main(int argc,char** argv)
 {
   if(argc<5)
   {
     usage();
     return -1;
   }
   /**************************************************************************************
    ***                       <-__*-*__--> PARSING <--__*-*__->                        ***
    **************************************************************************************/
   string fileNameL,fileNameR;
   StereoCalibration calibration;
   string width,height,squareSize;
   string undistortL,undistortR;
   for(int i = 1; i<argc; i++)
   {
     const char* s = argv[i];
     //return 0 if match
     if(!strcmp(s,"-w"))
       width=argv[++i];
     else if(!strcmp(s,"-h"))
       height=argv[++i];
     else if(!strcmp(s,"-sz"))
       squareSize=argv[++i];
     else if(!strcmp(s,"-single"))
     {
       //Need to redefine = ? , maybe
       string fileName=argv[++i];
       cout << "Single calibration file : " << fileName << endl;
       calibration = StereoCalibration(fileName,fileName);
       calibration.addFlag(CALIB_SAME_FOCAL_LENGTH);
     }
     else if(!strcmp(s,"-singleDiff"))
     {
       string fileNameCalibL = argv[++i];
       string fileNameCalibR = argv[++i];
       calibration = StereoCalibration(fileNameCalibL,fileNameCalibR);
     }
     else if(!strcmp(s,"-u"))
     {
       undistortL=argv[++i];
       undistortR=argv[++i];
     }
     else if(!strcmp(s,"-vids"))
     {
       fileNameL=argv[++i];
       fileNameR=argv[++i];
       cout <<"File name (left - right) : " << fileNameL << " - " << fileNameR << endl;
     }
     else if(!strcmp(s,"-stereo"))
     {
       string fileName = argv[++i];
       calibration = StereoCalibration(fileName);
     }
     else if(!strcmp(s,"-zt"))
       calibration.addFlag(CALIB_ZERO_TANGENT_DIST);
     else if(!strcmp(s,"-p"))
       calibration.addFlag(CALIB_FIX_PRINCIPAL_POINT);
   }
   if(!width.empty()&&!height.empty())
   {
     calibration.setWidth(width);
     calibration.setHeight(height);
     if(!squareSize.empty())
       calibration.setSquareSize(squareSize);
   } 
   //single calib file or stereo provided ? full calib ?
   if(!calibration.getStereoCalib())
   {
     if(fileNameL.empty()||fileNameR.empty())
     {
       usage();
       exit(EXIT_FAILURE);
     }
     else 
     {
       cout << "Call calibration from video ..." << endl;
       calibration.calibrateFromVideo(fileNameL,fileNameR);
       calibration.stereoCalib();
     }
   }
   	
   if(!undistortL.empty()&&!undistortR.empty())
   {
     /* Show undistorts frames*/
     namedWindow("Left Image",CV_WINDOW_KEEPRATIO);
     namedWindow("Right Image",CV_WINDOW_KEEPRATIO);
     VideoCapture CAPL(undistortL);
     VideoCapture CAPR(undistortR);
     
     Mat src_l,src_r,dest_l,dest_r;
     while(42)
     {   
       CAPL >> src_l;
       CAPR >> src_r;
       calibration.undistortion(src_l,&dest_l,src_r,&dest_r);
       imshow("Left Image",dest_l);
       imshow("Right Image",dest_r);
       char key = (char) waitKey(100);
     }
   } 
 }
