#ifndef _TRAITEMENT
#define _TRAITEMENT

#include <opencv2/core/core.hpp>
#include <opencv2/cudastereo.hpp>
#include <iostream>

using namespace std;
using namespace cv;
using namespace cv::cuda;

#define STEREOBM 1
#define STEREOBELIEFPROPAGATION 2
#define BILATERALFILTER 4
#define COLOR 8
// number of max disparities
#define NDISP 240
// higther -> smoth, lower -> more accurate || must be odd
#define WINSIZE 19

class StereoMatch
{
public:
  //1-> StereoBM || 2-> StereoBeliefPropagation || 4-> bilateral filter
  StereoMatch(int flag=STEREOBM);
  ~StereoMatch();
  void compute(Mat leftImg,Mat rightImg,Mat* disp);
private:
  int _flag;
  Ptr<cuda::StereoBM> _bm;
  Ptr<cuda::StereoBeliefPropagation> _bp;
  Ptr<cuda::DisparityBilateralFilter> _filter;
  GpuMat _leftGPU;
  GpuMat _rightGPU;
  GpuMat _dispGPU;
  GpuMat _dispColor;
  GpuMat _dispFiltered;
};

#endif
