#ifndef _TIMER
#define _TIMER

#include <iomanip>
#include <sstream>
#include <string>

using namespace std;

/*timer class for an approximation of app' fps*/
class Timer
{
private:
  int64 begin;
  double fps;
public:
  void start()
  { 
    begin = getTickCount(); 
  }
  void end()
  {
    int64 diff = getTickCount() - begin;
    double freq = getTickFrequency();
    fps = freq / diff;
  }
  string fastTxt()
  {
    stringstream string;
    string <<"FPS:" << setiosflags(ios::left) << setprecision(4) << fps;
    return string.str();
  }
};

#endif
