#ifndef __CAPTURE
#define __CAPTURE

#include <opencv2/highgui/highgui.hpp>
#include <string.h>
#include <algorithm> 
#include <stdexcept>
#define BUFFER_SIZE 75

using namespace std;
using namespace cv;

class Capture
{
private:
  char name[BUFFER_SIZE];
  VideoCapture capture;
  Mat frame;
  char* window_naming(char* s,int n){snprintf(s,BUFFER_SIZE,"Capture%.1d",n);}
public:
  // No need to build destructor, videocapture will be closed by VideoCapture destructor.
  Capture(int n,const string& filename)
  {
    //If user want to use cam, filename will be 0,1,2,n ... so we check if filename is digit (without extension).
    // lambda function  c++11 feature.
    if(all_of(filename.begin(),filename.end(),[](unsigned char c) {return isdigit(c)!=0;}))
      capture.open(atoi(filename.c_str()));
    else 
      capture.open(filename);
    if(!capture.isOpened())
      throw invalid_argument("Failed to open a video/webcam");
    else
    {
      capture >> frame;
      window_naming(name,n);
    }
  }
  bool takeScreenshot(int n);
  bool read();
};

#endif
  

  
  
  
