#ifndef _CALIB
#define _CALIB
#include <opencv2/core/core.hpp>
#include <opencv2/opencv.hpp>
#include <iostream>

using namespace std;
using namespace cv;

#define LEFT 1
#define RIGHT 2
#define NEED 10
#define SQUARESIZE 23

class StereoCalibration
{
private : 
  /*initUndistortRectifyMap computes the joint undistortion and rectification transformation and 
    represents the result in the form of maps*/
  vector<vector<Point2f> > _imagesPoints[2];
  vector<vector<Point3f> > _objectPoints;
  vector<Point2f> _corners[2];
  /*Output matrix -> rotation matrix, translation vector, essential matrix, fundamental matrix */
  /* vector of distortion coefficients */
  Mat _mapx[2],_mapy[2];
  Mat _R,_T,_E,_F;
  Mat _cameraMatrix[2], _distCoeffs[2];
  /*Rot -> rectification transform (rotation matrix)
    PL,PR -> projection matrix in the new (rectified) coordinate systems 
    D -> disparity-to-depth mapping matrix */
  Mat _rotation[2];
  Mat _projection[2];
  Mat _disparity;
  int _squareSize;
  Size _boardSize;
  Size _imgSize;
  unsigned int _nbFrames; // nb of frames necessary
  bool _patternFound; // true if pattern found during chessboard calibration
  bool _sameCamera; // true if cameraleft=cameraright (like 2 gopro black 3+)
  bool _singleCalib; // true if calibrate for single camera calibration
  bool _stereoCalib; // true if calibrate complete (or read from stereo calibration serialized file)
  int _flags;
public : 
  // Constructors
  StereoCalibration(unsigned int frame=NEED,unsigned int squareSize=SQUARESIZE):_nbFrames(frame),
										_squareSize(squareSize)
						     
  {
    _patternFound=false;
    _sameCamera=false;
    _singleCalib=false;  
    _stereoCalib=false;
  }
  StereoCalibration(string& StereoCalibration);
  StereoCalibration(string& calibrationFileL,string& calibrationFileR);
  //Serialize
  void save(string fileName="stereo.yml");
  //Getter
  const bool getPatternFound() const {return _patternFound;}
  const bool getSameCamera() const {return _sameCamera;}
  const bool getSingleCalib() const {return _singleCalib;}
  const bool getStereoCalib() const {return _stereoCalib;}
  Mat getReprojectionMat(){return _disparity;}
  //Setter
  void setWidth(string width);
  void setHeight(string height); 
  void setSquareSize(string height);
  void addFlag(int flag);
    
  void stereoCalib();
  void initialize();
  void calibrateFromVideo(string& vid_left, string& vid_right, unsigned int nbFrames=NEED);
  bool findChessboardCornersAndDraw(Mat& mat_left, Mat& mat_right);
  void undistortion(Mat & src,Mat* dest,unsigned short int flag);
  /* Important function, so I prefer to put it inline */
  void undistortion(Mat & src_left,Mat* dest_left,Mat & src_right,Mat* dest_right)
  {
    undistortion(src_left,dest_left,LEFT);
    undistortion(src_right,dest_right,RIGHT);
  }
  
  
};

#endif
