/*
Copyright (c) 2014-2015, Conor Stokes
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef INDEX_BUFFER_COMPRESSION_FORMAT_H__
#define INDEX_BUFFER_COMPRESSION_FORMAT_H__
#pragma once

enum IndexBufferCompressionFormat
{
    // Per indice encoding - handles degenerates, but has worse compression/decompression speed and compression.
    IBCF_PER_INDICE_1 = 0,

    // Per triangle encoding - better compression/speed, does not handle degenerates.
    IBCF_PER_TRIANGLE_1 = 1,

    // Automatically pick the best encoding dependent on whether degenerate triangles are detected in the mesh.
    // Will take longer to compress (due to the degenerate triangle check).
    IBCF_AUTO = 2,

	// Uses a similar coder to the ICBF_PER_TRIANGLE_1 coder, but does not use the edge 0 and 1 new codes
	// Uses a prefix based entropy encoder (same family as huffman and polar codes), with fixed
	// table coding.
	IBCF_PER_TRIANGLE_PREFIX_ENTROPY = 3
};

#endif // -- INDEX_BUFFER_COMPRESSION_FORMAT_H__