#include <cstdlib>
#include <iostream>
#include <QDebug>
#include <QApplication>
#include <QImage>

#include "MeshWindow.hpp"



int main(int argc, char** argv) {

  QApplication app(argc, argv);


  MeshWindow *window = new MeshWindow();

  window->show();


  if (argc > 1) {
    const char *meshFilename = argv[1];
    window->loadMeshFile(meshFilename);
  }

  if (argc > 2) {
    const char *imageFilename = argv[2];
    window->loadImageFile(imageFilename);
  }
  
  if (argc > 3) {
   const char *outMeshFilename = argv[3];
   window->computeTextureCoords(outMeshFilename);
  }
  
  return app.exec();
}

