import java.io.*;
import java.text.*;
import java.util.*;

public class Test{

    private static void usage(){
	System.out.println("Usage : Test nbGraphes nbMaxSommets poidsMaxi");
    }
    public static void main(String[] args) throws Exception {
	if (args.length < 3)
	    usage();
	else {
	    int nbTests = Integer.parseInt(args[0]);
	    int nbMaxSommets = Integer.parseInt(args[1]);
	    int poidsMaxi = Integer.parseInt(args[2]);
	    // les differentes implementation d'un meme graphe
	    Graphe[] gr = new Graphe[1];
	    // pour chaque implementation, 
	    // les statistiques pour les algorithmes compares
	    int[][][] stats = new int[gr.length][3][2];
	    // pour fabriquer aleatoirement les graphes
	    Random alea = new Random();
	    // pour sauvegarder les statistiques
	    FileWriter res = new FileWriter("graphesComplexites.csv");
	    res.write(",NbSommets,NbAretes"+
		      "arbreCouvrantPrim,,"+
		      "arbreCouvrantPrimTas,,"+
		      "arbreCouvrantKruskal,\n");
	    res.write(",,,"+
		      "NbLectures,NbEcritures,"+
		      "NbLectures,NbEcritures,"+
		      "NbLectures,NbEcritures\n");
	    res.write("\n");
	    // une serie de graphes differents
	    for (int num=0; num<nbTests; num++){
		// Creation et sauvegarde du graphe au format dot
		FileWriter dot = new FileWriter("graphe"+num+".dot");
		dot.write("digraph \"Graphe"+num+"\" {\n"+
			  "\tnode[shape=\"box\"]\n");
		// dimentionnement du graphe (sommets, aretes)
		int nbSommets = alea.nextInt(nbMaxSommets)+1;
		for (int i=0; i<nbSommets; i++)
		    dot.write("\ts"+i+"[]\n");
		int nbAretes = alea.nextInt((nbSommets * nbSommets +1)/2);
		System.out.println("\tCreation du graphe numero : "+num+
				   "\n\t\tNombre de sommets : "+nbSommets+
				   " Nombre d'aretes : "+nbAretes);
		gr[0] = new GrapheListe(nbSommets);
		
		// creation aleatoire des aretes
		// pas d'aretes double (verifier dans addArete()
		for (int i=0; i<nbAretes; i++){
		    System.out.print(i+" ");
		    int n,ori,but,poids;
		    do {
			n = alea.nextInt(nbSommets * nbSommets);
			ori = n/nbSommets;
			but = n%nbSommets;
			poids = alea.nextInt(poidsMaxi);
		    }
		    while ((ori==but) ||
			   !gr[0].addArete(n/nbSommets, n%nbSommets, poids));
		    dot.write("\ts"+n/nbSommets+
			      " -> s"+n%nbSommets+"[label="+poids+"]\n");
		}
		dot.write("}\n");
		dot.close();		
		// Comparaison des algorithmes
		System.out.println("\tCalcule des complexites du graphe numero : "+num);
		int s = alea.nextInt(nbSommets);
		for (int g=0; g<gr.length; g++) {
		    gr[g].arbreCouvrantPrim(gr[g].getSommet(s));
 		    stats[g][0][0] = gr[g].getStats()[0];
 		    stats[g][0][1] = gr[g].getStats()[1];
		    gr[g].arbreCouvrantPrimTas(gr[g].getSommet(s));
 		    stats[g][1][0] = gr[g].getStats()[0];
 		    stats[g][1][1] = gr[g].getStats()[1];
		    gr[g].arbreCouvrantKruskal();
 		    stats[g][2][0] = gr[g].getStats()[0];
 		    stats[g][2][1] = gr[g].getStats()[1];
		}
		// sauvegarde des resultats
		res.write("Graphe "+num+","+nbSommets+","+nbAretes);
		for (int g=0; g<gr.length; g++) {
		    for (int algo=0; algo<stats[g].length; algo++)
			for (int c=0; c<stats[g][algo].length; c++)
			    res.write(","+stats[g][algo][c]);
		    res.write("\n");
		    res.flush();
		}
		res.write("\n");
	    }
	    res.close();
	}
    }
}
