import java.util.*;

public class Tas extends ArrayList{

    public Tas(){
	super();
    }
    
    public Tas(Sommet[] s, GrapheListe g){
	super(s.length);
	g.incStatEcriture(s.length);
	for (int i = 0; i < s.length; i++){
	    add(i, s[i]);
	    s[i].setIndiceDansF(i);
	}
	for (int i = (size()-1)/2; i>=0; i--)
	    entasser(i,g);
    }

    public final int getIndiceFg(int i)   {return 2*i+1;}
    public final int getIndiceFd(int i)   {return 2*(i+1);}
    public final int getIndicePere(int i) {return (i-1)/2;}

    /**
     *
     *
     **/
    private int getComparator(int i) {
	return ((Sommet)get(i)).getDistanceArbreCouvrant();
    }

    /**
     *
     *
     **/
    private void entasser(int i, GrapheListe g){
	int fg = getIndiceFg(i);
	int fd = getIndiceFd(i);
        int min = i;
	if (fg < size() && getComparator(fg) < getComparator(min))
	    min = fg;
	if (fd < size() && getComparator(fd) < getComparator(min))
	    min = fd;
	if (min != i){
	    g.incStatEcriture(2);
	    Sommet aux = (Sommet)get(i);
	    Sommet auxMin = (Sommet)get(min);
	    set(i,auxMin);
	    auxMin.setIndiceDansF(i);
	    set(min,aux);
	    aux.setIndiceDansF(min);
	    entasser(min,g);
	}
    }

    /**
     *
     *
     **/
    public final Sommet extraireMinimum(GrapheListe g){
	if (size()==0)
	    return null;
	g.incStatLecture(2);
	Sommet ab = (Sommet)get(0);
	Sommet aux = (Sommet)remove(size()-1);
	if (size()>0){
	    g.incStatEcriture(1);
	    set(0, aux);
	    aux.setIndiceDansF(0);
	    entasser(0,g);
	}
	g.incStatEcriture(1);
	ab.setDansF(false);
	return ab;
    }
    
    /**
     *
     *
     **/
    public final void diminuerClef(Sommet s, Arete e, Sommet t, GrapheListe g){
	t.setPere(s);
	t.setDistanceArbreCouvrant(e.getPoids());
	g.incStatEcriture(1);
	int indice = t.getIndiceDansF();
	while(indice>0 && (getComparator(getIndicePere(indice)) > 
			   t.getDistanceArbreCouvrant())){
	    g.incStatEcriture(1);
	    Sommet aux = (Sommet)get(getIndicePere(indice));
	    set(indice,aux);
	    aux.setIndiceDansF(indice);
	    indice = getIndicePere(indice);
	}
	g.incStatEcriture(1);
	set(indice,t);
	t.setIndiceDansF(indice);
    }

}
