import java.util.*;
import java.math.*;

public class GrapheListe implements Graphe{

    // Les structures pour coder le graphe
    private Sommet[] sommets;
    private LinkedList[] adjacents;

    // les variables globales pour les statistiques
    private int[] stats = new int[2]; 
    // 0 pour les lecture des Sommets et Aretes; 
    // 1 pour les ecriture des Sommets et Aretes; 

    public GrapheListe(int n){
	sommets = new Sommet[n];
	adjacents = new LinkedList[n];
	for (int i=0; i<n; i++) {
	    sommets[i] = new Sommet(i);
	    adjacents[i] = new LinkedList();
	}
    }

    private void resetStats() {
	for (int i=0; i<stats.length; i++)
	    stats[i] = 0;
    }

    public void incStatLecture(int i) {
	stats[0] += i;
    }

    public void incStatEcriture(int i) {
	stats[1] += i;
    }

    public int[] getStats() {
	return stats;
    }

    public int getNbSommets() {
	return sommets.length;
    }

    public int getNbAretes() {
	int total = 0;
	for (int i=0; i<adjacents.length; i++)
	    total += adjacents[i].size();
	return total;
    }

    public boolean addArete(int s, int t, int w) {
	Arete e = new Arete(w,sommets[s],sommets[t]);
	/**
	 * Pour ne pas avoir d'aretes multiples
	 **/
	boolean deja = false;
	for (int i = 0; i<adjacents.length; i++)
	    for (Iterator it = adjacents[i].iterator(); 
		 it.hasNext() && !deja;) {
		Arete old = (Arete)it.next();
		deja = deja | e.compareTo(old)==0;
	    }
	if (deja) {
	    System.out.println("deja "+e);
	    return false;
	}
	else {
	    adjacents[s].add(new Arete(w,sommets[s],sommets[t]));
	    adjacents[t].add(new Arete(w,sommets[t],sommets[s]));
	    return true;
	}
    }
    
    public Sommet getSommet(int i) {
	return sommets[i];
    }

    /** Complexite
     *  Nombre de lectures = 
     *                     : O()
     *  Nombre de ecritures = 
     *                     : O()
     **/
    public void arbreCouvrantPrim(Sommet r) {
	resetStats();
	initialisationPrim(r);
	Sommet s;
	do {
	    s = extraireMinimum();
	    if (s != null) {
		for (Iterator it = adjacents[s.getIdent()].iterator();
		     it.hasNext();) {
		    Arete e = (Arete)it.next();
		    Sommet t = e.getAutreSommet(s);
		    incStatLecture(2);
		    if (t.isDansF() && 
			e.getPoids() < t.getDistanceArbreCouvrant())
			diminuerClef(s,e,t);
		}
	    }
	}
	while (s != null);
	affichageArbreCouvrantPrim();
    }
    
    /** Complexite
     *  Nombre de lectures = 
     *                     : O()
     *  Nombre de ecritures = 
     *                     : O()
     **/
    public void arbreCouvrantPrimTas(Sommet r) {
	resetStats();
	initialisationPrim(r);
	// A COMPLETER
	affichageArbreCouvrantPrim();
    }
    
    /** Complexite
     *  Nombre de lectures = 
     *                     : O()
     *  Nombre de ecritures =
     *                      : O(1)
     **/
    public void arbreCouvrantKruskal() {
	resetStats();
	initialisationKruskal();
	SortedSet arbreCouvrant = new TreeSet();
	// A COMPLETER
	affichageArbreCouvrantKruskal(arbreCouvrant);
    }

    /** Les methodes privees pour PRIM
     **/    
    private void initialisationPrim(Sommet s){
	for (int i = 0; i<sommets.length; i++){
	    sommets[i].setDansF(true);
	    sommets[i].setDistanceArbreCouvrant(Integer.MAX_VALUE);
	}
	s.setDistanceArbreCouvrant(0);
	s.setPere(null);
	incStatEcriture(sommets.length);
    }
    
    private Sommet extraireMinimum(){
	int min = Integer.MAX_VALUE;
	Sommet res = null;
	for (int i = 0; i<sommets.length; i++){
	    if (sommets[i].isDansF() && 
		sommets[i].getDistanceArbreCouvrant() <= min) {
		min = sommets[i].getDistanceArbreCouvrant();
		res = sommets[i];
	    }
	}
	incStatLecture(sommets.length);
	if (res != null) {
	    res.setDansF(false);
	    incStatEcriture(1);
	}
	return res;
    }
    
    private void diminuerClef(Sommet s, Arete e, Sommet t) {
	t.setPere(s);
	t.setDistanceArbreCouvrant(e.getPoids());
	incStatEcriture(1);
    }

    private void affichageArbreCouvrantPrim(){
	System.out.println("Les aretes couvrantes pour Prim");
	int poidsTotal = 0;
	for (int i=0; i<adjacents.length; i++) {
	    for (Iterator it = adjacents[i].iterator(); it.hasNext();) {
		Arete e = (Arete)it.next();
		// pour n'avoir qu'un seul exemplaire de chaque arete
		if (sommets[i].getIdent()==e.getPremierSommet().getIdent())
		    if (e.getPremierSommet().getPere()==e.getSecondSommet() ||
			e.getSecondSommet().getPere()==e.getPremierSommet()) {
			poidsTotal += e.getPoids();
			System.out.println("\t"+e);
		    }
	    }
	}
	System.out.println("\tPoids total : "+poidsTotal);
    }
    
    /** Les methodes privees pour KRUSKAL
     **/    
    private void initialisationKruskal(){
	for (int i = 0; i<sommets.length; i++){
	    sommets[i].setRepresentant(i);
	}
	incStatEcriture(sommets.length);
    }
    
    private SortedSet trierAretes(){
	SortedSet aretes = new TreeSet();
	for (int i=0; i<adjacents.length; i++) {
	    for (Iterator it = adjacents[i].iterator(); it.hasNext();) {
		Arete e = (Arete)it.next();
		// pour n'avoir qu'un seul exemplaire de chaque arete
		if (sommets[i].getIdent()==e.getPremierSommet().getIdent())
		    aretes.add(e);
	    }
	}
	BigInteger bi = 
	    new BigInteger((new Integer(getNbAretes()).toString()));
	int log2NbAretes = bi.bitLength();
	// Estimation de la complexite du tri
	incStatLecture(getNbAretes()*log2NbAretes);
	incStatEcriture(getNbAretes());
	return aretes;
    }

    private void affichageArbreCouvrantKruskal(SortedSet ab){
	System.out.println("Les aretes couvrantes pour Kruskal");
	int poidsTotal = 0;
	for (Iterator it = ab.iterator(); it.hasNext();) {
	    Arete e = (Arete)it.next();
	    poidsTotal += e.getPoids();
	    System.out.println("\t"+e);
	}
	System.out.println("\tPoids total : "+poidsTotal);
    }
    
}
