import java.util.*;

public class Arete implements Comparable {

    int poids;
    Sommet s1, s2; // s1.ident() < s2.ident()
    boolean dansArbreCouvrantPrim;
    boolean dansArbreCouvrantKruskal;
 
    public Arete(int w, Sommet s, Sommet t){
	poids = w;
	if (s.getIdent() > t.getIdent()) {
	    Sommet aux = s;
	    s = t;
	    t = aux;
	}
	s1 = s;
	s2 = t;
    }

    public int getPoids(){return poids;}
    public Sommet getPremierSommet(){return s1;}
    public Sommet getSecondSommet(){return s2;}
    public Sommet getAutreSommet(Sommet s){
	if (s1.getIdent()==s.getIdent())
	    return s2;
	return s1;
    }

    public String toString(){
	return "["+s1+" - "+s2+"] poids : "+poids;
    }
    
    /** Note: 
     *  this class has a natural ordering that is inconsistent with equals
     *  Ordre utilise dans les "SortedSet"
     **/
    public int compareTo(Object a){
	if (s1.getIdent() == ((Arete)a).getPremierSommet().getIdent() &&
	    s2.getIdent() == ((Arete)a).getSecondSommet().getIdent())
	    return 0;
	else if (poids < ((Arete)a).getPoids())
	    return -1;
	else 
	    return 1;
    }
    
}
