#define _POSIX_C_SOURCE 1
#include <sys/types.h>
#include <errno.h>
#include <unistd.h>
#include <setjmp.h>
#include <stdio.h>
#include <stdlib.h>
#include "tuber.h"

static jmp_buf retour_erreur;
static int tube[2];

int
tuber_resultat(char *commande[])
{
    pid_t pid;

    if (setjmp(retour_erreur) == 1)
    {
	perror(NULL);
	close(tube[0]);
	close(tube[1]);
	return -1;
    }

    if (pipe(tube) == -1)
	longjmp(retour_erreur, 1);
    pid = fork();
    if (pid == -1)
	longjmp(retour_erreur, 1);

    if (pid == 0)
    {
	/* Processus enfant */
        close(1);
        dup(tube[1]);
        close(tube[0]);
        close(tube[1]);

	execvp(commande[0], commande);
        perror(commande[0]);
        exit(EXIT_FAILURE);
    }

    /* Processus parent */
    close(tube[1]);
    return tube[0];
}
