#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "ec_tailles.h"
#include "lire_chaine.h"

static void chercher(void);
static void trier(void);
static int comparer_elements(char **e1, char **e2);
static int comparer_classes(char **e1, char **e2);

static char *symboles[] = 
{ 
 "A_t", "EXIT", "Z1", "Z2", "__", "__au", "_exit",
 "_z2", "ar", "a_t", "au", "ex__it", "z_1", "z_2"
};

int 
main(void)
{
    unsigned i;

    trier();
    for (i = 0; i < EC_NOMBRE_D_ELEMENTS(symboles); i++)
	printf("%s ", symboles[i]);
    printf("\n\n");
    chercher();
    return EXIT_SUCCESS;
}

static void
trier(void)
{
    qsort(symboles, EC_NOMBRE_D_ELEMENTS(symboles), 
	  sizeof symboles[0], comparer_elements);
}

static void 
chercher(void)
{
    for (;;)
    {
	char *cherche = lire_chaine("-> ");
	char **trouve;
	
	if (cherche == NULL)
	    break;
	trouve = bsearch(&cherche, symboles, 
			 EC_NOMBRE_D_ELEMENTS(symboles), 
			 sizeof symboles[0], comparer_elements);
	if (trouve == NULL)
	{
	    trouve = bsearch(&cherche, symboles, 
			     EC_NOMBRE_D_ELEMENTS(symboles), 
			     sizeof symboles[0], comparer_classes);
	    if (trouve == NULL)
	    {
		printf("Pas de symbole correspondant  \"%s\"\n", 
		       cherche);
		free(cherche);
		continue;
	    }
	}
	printf("\"%s\" -> \"%s\"\n", cherche, *trouve);
	free(cherche);
    }
    printf("\n");
}
 

static int 
comparer_classes(char **e1, char **e2)
{
    char *p1 = *e1;
    char *p2 = *e2;

    for (;;)
    {
	char c1;
	char c2;

	while (*p1 == '_')
	    p1++;
	while (*p2 == '_')
	    p2++;
	c1 = toupper(*p1);
	c2 = toupper(*p2);
	if (c1 != c2)
	    return c1 - c2;
	if (c1 == '\0') /* et par consquent c2 == '\0' */
	    return 0;
	p1++;
	p2++;;
    }
}

static int
comparer_elements(char **e1, char **e2)
{
    int c = comparer_classes(e1, e2);
    
    if (c != 0)
	return c;
    return strcmp(*e1, *e2);
}
