#include <stdlib.h>
#include <stdio.h>
#include "malldmp.h"

static void *trace_malloc(size_t taille);
static void *trace_realloc(void *p, size_t taille);

int 
main(void)
{
    char *p01 = trace_malloc(1);
    char *p02 = trace_malloc(2);

    trace_malloc(11);
    trace_malloc(12);
    trace_malloc(13);
    trace_malloc(14);

    strcpy(p02, "p02");
    printf("p01 + decalage(p01) --> \"%s\"\n",
	   p01 + malldmp_entete(p01)-1);
        
    p02 = trace_realloc(p02, 11);
    p02 = trace_realloc(p02, 12);
    p02 = trace_realloc(p02, 13);
    p02 = trace_realloc(p02, 14);

    return EXIT_SUCCESS;
}

static void *
trace_malloc(size_t taille)
{
    void *p = malloc(taille);

    printf("malloc(%02d): ", taille);
    malldmp(p);
    printf("\n");
    return p;
}

static void *
trace_realloc(void *p, size_t taille)
{
    void *q;

    printf("realloc(%p,%02d)", p, taille);
    q = realloc(p, taille);
    printf(" = %p: ", q);
    malldmp(q);
    printf("\n");
    return q;
}
