#include <stdio.h>
#include <stdlib.h>
#include "exit_if.h"
#include "erreurs.h"
#include "instancier.h"
#include "totalisateur.h"

struct emplacement
{
    struct emplacement *suivant;
    roue_num roue;
};

struct totalisateur
{
    int nombre_de_roues;
    struct emplacement *premier_emplacement;
};

static void afficher(struct emplacement *, void (*)(int));

totalisateur 
totalisateur_faire()
{
    INSTANCIER(totalisateur);

    recv->nombre_de_roues = 0;
    recv->premier_emplacement = NULL;
    return recv;
}

void 
totalisateur_defaire(totalisateur recv)
{
    struct emplacement *p = recv->premier_emplacement;
    
    while (p != NULL)
    {
        struct emplacement *q = p;

        p = p->suivant;
        roue_num_defaire(q->roue);
        free(q);
    }
    free(recv);
}

void 
totalisateur_ajouter_roue(totalisateur recv, roue_num r)
{
    struct emplacement *p = malloc(sizeof(struct emplacement));
    EXIT_IF(p==NULL, err_malloc);

    p->roue = r;
    p->suivant = recv->premier_emplacement;
    recv->premier_emplacement = p;
    (recv->nombre_de_roues)++;
}

void 
totalisateur_initialiser(totalisateur recv)
{
    struct emplacement *p =  recv->premier_emplacement;

    while (p != NULL)
    {
        roue_num_initialiser(p->roue);
        p = p->suivant;
    }
}

void 
totalisateur_avancer(totalisateur recv)
{
    struct emplacement *p =  recv->premier_emplacement;

    while (p != NULL)
    {
        if (roue_num_avancer(p->roue))
            break;
        p = p->suivant;
    }
}

int 
totalisateur_nombre_de_roues(totalisateur recv)
{
    return recv->nombre_de_roues;
}

void 
totalisateur_afficher(totalisateur recv, void (*f)(int))
{
    afficher(recv->premier_emplacement, f);
}

static void 
afficher(struct emplacement *p, void (*f)(int))
{
    if (p != NULL)
    {
        afficher(p->suivant, f);
        f(roue_num_valeur(p->roue));
    }
}
