#define _POSIX_C_SOURCE 1
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <stddef.h>

static char *nom = "ES.test";

static void defiler_jusqu_a(int fd, char c);
static int ecrire_chaine(int fd, char *s);

int 
main(void)
{
    int fd_1 = open (nom, O_WRONLY|O_CREAT|O_TRUNC, S_IRUSR|S_IWUSR);
    int fd_2 = open (nom, O_RDWR);

    if (fd_1 == -1 || fd_2 == -1)
    {
	perror(nom);
	return EXIT_FAILURE;
    }

    ecrire_chaine(fd_1, "abcdefghijklmnopqrstuvwxyz");

    ecrire_chaine(fd_2, "<1>");
    defiler_jusqu_a(fd_2, 'm');
    ecrire_chaine(fd_2, "<2>");
    defiler_jusqu_a(fd_2, 'z');
    ecrire_chaine(fd_2, "0123456789\n");

    ecrire_chaine(fd_1, "***");
    close(fd_1);
    close(fd_2);
    return EXIT_SUCCESS;
}

static int
ecrire_chaine(int fd, char *s)
{
    return write(fd, s, strlen(s));
}

static void 
defiler_jusqu_a(int fd, char c)
{
    for (;;)
    {
        char caractere_lu;

        if (read(fd, &caractere_lu, sizeof caractere_lu) <= 0
            || caractere_lu == c)
            return;
    }
}
