#include <stdlib.h>
#include <stdio.h>

#include "generateur.h"
#include "historique.h"

#include "test_historique.def"

#define TAILLE_HISTORIQUE 6

static void prompt(void);

int 
main(void)
{
    historique petit_historique = historique_faire(TAILLE_HISTORIQUE);

    prompt();
    for (;;)
    {
        int c = getchar();

        if (c == EOF)
            break;

        switch (c)
        {
          case  NOUVEL_HISTORIQUE :
            historique_defaire(petit_historique);
            petit_historique = historique_faire(TAILLE_HISTORIQUE);
            break;

          case ALLER_EN_FIN:
            historique_aller_a_la_fin(petit_historique);
            break;

          case AFFICHER_PRECEDENT:
            printf("(%c)", historique_precedent(petit_historique));
            break;

          default:
            historique_ajouter(petit_historique, c);
            break;

          case '\n':
            prompt();
            /* NOBREAK */
          case ' ':
          case '\t':
            break;
        }
    }
    printf("\n");
    return EXIT_SUCCESS;
}

static void 
prompt(void)
{
    printf("\n[%d]: ", generateur_suivant());
}
