#include <stdlib.h>
#include <stdio.h>

#include "generateur.h"
#include "c_anneau.h"

#include "test_anneau.def"

#define TAILLE_ANNEAU 6

static void prompt(void);

int 
main(void)
{
    c_anneau anneau = c_anneau_faire(TAILLE_ANNEAU);

    prompt();
    for (;;)
    {
        int c = getchar();

        if (c == EOF)
            break;

        switch (c)
        {
          case  NOUVEL_ANNEAU :
            c_anneau_defaire(anneau);
            anneau = c_anneau_faire(TAILLE_ANNEAU);
            break;

          case ALLER_EN_FIN:
            c_anneau_aller_au_dernier(anneau);
            break;

          case AFFICHER_PRECEDENT:
            printf("(%c)", c_anneau_precedent(anneau));
            break;

          default:
            c_anneau_ajouter(anneau, c);
            break;

          case '\n':
            prompt();
            /* NOBREAK */
          case ' ':
          case '\t':
            break;
        }
    }
    printf("\n");
    return EXIT_SUCCESS;
}

static void 
prompt(void)
{
    printf("\n[%d]: ", generateur_suivant());
}
