#define _POSIX_C_SOURCE 1
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include "systeme.h"

int 
systeme(char *commande)
{
    pid_t pid = fork();
    int etat;

    if (pid == -1)
    {
	perror(NULL);
	return 0;
    }
    if (pid == 0)
    {
        execlp("sh", "sh", "-c", commande, NULL);
	perror("sh");
	exit(EXIT_FAILURE);
    }
    if (waitpid(pid, &etat, WUNTRACED) == -1)
	return 0;
    if (WIFEXITED(etat))
	return 1;
    if (WIFSIGNALED(etat))
	fprintf(stderr, 
		"Terminaison anormale (signal=%d)\n", 
		WTERMSIG(etat));
    else
	fprintf(stderr, 
		"Processus %d arrt (signal=%d)\n", 
		pid, WSTOPSIG(etat));
    return 0;

}
